import cv2
import numpy as np

def unsharp_masking(img, kernel_size=5, threshold=2.0):
    if kernel_size % 2 == 0:
        kernel_size += 1  # Ensure the kernel size is odd
    gaussian = cv2.GaussianBlur(img, (kernel_size, kernel_size), 2.0)
    unsharp_mask = cv2.addWeighted(img, threshold, gaussian, -1.0, 0)
    # Clip the pixel values to the valid range [0, 255]
    unsharp_mask = np.clip(unsharp_mask, 0, 255)
    # Normalize the image to bring pixel values back to [0, 255]
    cv2.normalize(unsharp_mask, unsharp_mask, 0, 255, cv2.NORM_MINMAX)
    return unsharp_mask
