import gradio as gr
import tensorflow as tf
import tensorflow_io as tfio
import numpy as np

loaded_model = tf.keras.models.load_model('kidney2.h5')

label_names = {
    "1": "Cyst",
    "2": "Normal",
    "3": "Stone",
    "4": "Tumor"
}

def classify_kidney_image(img):
    resize = tf.image.resize(img, (224, 224))
    gray = tfio.experimental.color.bgr_to_rgb(resize)
    normalized_img = gray / 255.0
    yhat = loaded_model.predict(np.expand_dims(normalized_img, 0))
    class_index = np.argmax(yhat, axis=1)[0]
    predicted_label = label_names[str(class_index + 1)]
    probabilities = {label_names[str(i + 1)]: str(prob) for i, prob in enumerate(yhat[0])}
    return predicted_label, probabilities

image = gr.inputs.Image(shape=(224, 224))
label = gr.outputs.Label()

app = gr.Interface(fn=classify_kidney_image, inputs=image, outputs=label, interpretation='default', title='Kidney Image Classifier')
app.launch(debug=True)
