import gradio as gr


def saudar(nome):
    return "Olá " + nome

título = "Uma Estratégia de Aprendizado de Máquina para a Fenotipagem Automática de Gravidezes de Alto Risco"
descrição = """
O bot foi treinado para segmentar, medir e fazer previsões informadas sobre gravidezes de alto risco com base no perímetro cefálico (HC) do crânio fetal. Ele utiliza técnicas de processamento de imagens para identificar e quantificar informações relevantes, permitindo uma avaliação mais precisa e preditiva do risco associado à gravidez.




"""
# <img src="https://huggingface.co/spaces/course-demos/Rick_and_Morty_QA/resolve/main/rick.png" width=200px>
artigo = "Confira [o repositório do GitHub](https://github.com/MarkTLite) no qual este site e modelo são baseados."

import cv2, math
import matplotlib.pyplot as plt
import numpy as np
from tensorflow.keras.utils import normalize
from tensorflow.keras.models import load_model
from skimage import measure


def prever(img):
    img = img.reshape((256,256,1))
    img_normalizada = normalize(img, axis=1)
    # carregar o modelo
    modelo = load_model('model-best.h5', compile=False)
    modelo.compile(optimizer='adam', loss="binary_crossentropy")
    img_teste = img_normalizada
    img_original = img
    img_normalizada = img_teste[:,:,0]
    img_entrada = np.expand_dims(img_normalizada, 0)

    # Prever e aplicar limiar para valores acima de 0.08 de probabilidade
    previsão = (modelo.predict(img_entrada) > 0.08).astype(np.uint8)
    previsão = previsão[0]
    imagem_rótulo = measure.label(previsão, connectivity=img_original.ndim)

    fig, ax = plt.subplots()
    ax.imshow(imagem_rótulo[:,:,0], cmap=plt.cm.gray)
    regiões = measure.regionprops(imagem_rótulo[:,:,0])
    hc_anterior, hc = 0,0 
    for props in regiões:
        y0, x0 = props.centroid
        orientação = props.orientation
        x1 = x0 + math.cos(orientação) * 0.5 * props.minor_axis_length
        y1 = y0 - math.sin(orientação) * 0.5 * props.minor_axis_length
        x2 = x0 - math.sin(orientação) * 0.5 * props.major_axis_length
        y2 = y0 - math.cos(orientação) * 0.5 * props.major_axis_length

        distância_menor = ((x0 - x1)**2 + (y0 - y1)**2)**0.5
        print(distância_menor*2)
        distância_maior = ((x0 - x2)**2 + (y0 - y2)**2)**0.5
        print(distância_maior*2)
        hc_anterior = 1.62*(distância_menor+distância_maior)
        if(hc_anterior>hc):
            hc = hc_anterior
        print("HC = ",hc, " mm")

        ax.plot((x0, x1), (y0, y1), '-r', linewidth=2.5)
        ax.plot((x0, x2), (y0, y2), '-r', linewidth=2.5)
        ax.plot(x0, y0, '.g', markersize=15)

    plt.show()

    # Sobrepõe a previsão na imagem original
    img_desenhada = cv2.cvtColor(img_original, cv2.COLOR_GRAY2BGR)
    contornos, hierarquia = cv2.findContours(previsão, cv2.RETR_TREE, cv2.CHAIN_APPROX_NONE)
    cv2.drawContours(img_desenhada, contornos, -1, (255,0,0), 2)
    return img_desenhada, "Perímetro Cefálico = " + str(hc) + " mm"

exemplos = [    ['image.png']
]

gr.Interface(prever, gr.Image(shape=(256, 256), image_mode='L'), [gr.outputs.Image(type='plot'), 'text'],
             description=descrição, article=artigo, title=título, examples=exemplos, analytics_enabled=False).launch()
