import streamlit as st
import pydicom
import matplotlib.pyplot as plt
import os

def visualize_dicom_sequence(file_path):
    ds = pydicom.dcmread(file_path)
    image_sequence = ds.pixel_array

    if image_sequence.ndim == 2:
        # Only one image in the sequence
        fig, ax = plt.subplots()
        ax.imshow(image_sequence, cmap=plt.cm.gray)
        ax.axis('off')
        st.pyplot(fig)
    else:
        # Multiple images in the sequence
        for i, image in enumerate(image_sequence):
            fig, ax = plt.subplots()
            ax.imshow(image, cmap=plt.cm.gray)
            ax.axis('off')
            st.pyplot(fig)

def main():
    st.title("Visualizador DICOM")

    # Upload DICOM file
    uploaded_file = st.file_uploader("Selecione um arquivo DICOM", type=".dcm")

    if uploaded_file is not None:
        # Convert uploaded file to bytes
        file_bytes = uploaded_file.getvalue()

        # Save the uploaded file to a temporary location
        with open("temp.dcm", "wb") as f:
            f.write(file_bytes)

        # Visualize the DICOM image sequence
        visualize_dicom_sequence("temp.dcm")

        # Remove the temporary file
        os.remove("temp.dcm")

if __name__ == "__main__":
    main()
