import gradio as gr
import numpy as np
from tensorflow.keras.preprocessing import image
from tensorflow.keras.models import load_model
from PIL import Image as PILImage
import io

# Carregar o modelo treinado
model = load_model('model_1.0000.h5')

def predict_and_invert(input_image):
    input_image = input_image.resize((224, 224))
    img = image.img_to_array(input_image) / 255.0
    img = np.expand_dims(img, axis=0)
    img = img[:, :224, :224, :]

    prediction = model.predict(img)

    if prediction[0][0] > 0.5:
        result = "Anomalia cardíaca (Doente)"
    else:
        result = "Normal (Sem anomalia)"

    img_inverted = 1 - img[0]  # Inverter a imagem

    img_inverted_pil = PILImage.fromarray(np.uint8(img_inverted * 255))
    img_inverted_bytes = io.BytesIO()
    img_inverted_pil.save(img_inverted_bytes, format='PNG')

    return result, img_inverted_pil

# Criar uma interface Gradio
iface = gr.Interface(
    fn=predict_and_invert,
    inputs=gr.inputs.Image(type="pil", label="Carregar uma imagem"),
    outputs=["text", "image"]
)

# Executar a interface Gradio
iface.launch()
