import os
import numpy as np
import tensorflow as tf
from tensorflow.keras.preprocessing import image
import gradio as gr

os.environ['CUDA_VISIBLE_DEVICES'] = '-1'

def pred(image_array):
    model = tf.keras.models.load_model('alzheimer_99.5.h5')
    result = ['Mild_Demented', 'Moderate_Demented', 'Non_Demented', 'Very_Mild_Demented']
    
    img = image.img_to_array(image_array)
    img = tf.image.resize(img, (224, 224))  # Resize the image
    img = np.expand_dims(img, axis=0)
    img = img / 255.0  # Assuming the model expects input in the range [0, 1]
    
    pred = model.predict(img)
    pred_class = np.argmax(pred, axis=1)[0]
    prediction = result[pred_class]
    probability = pred[0][pred_class]
    
    class_explanations = {
        'Mild_Demented': 'Condição de demência leve.',
        'Moderate_Demented': 'Condição de demência moderada.',
        'Non_Demented': 'Sem sinais de demência.',
        'Very_Mild_Demented': 'Condição de demência muito leve.'
    }
    explanation = class_explanations.get(prediction, 'Unknown')
    
    return prediction, probability, explanation

iface = gr.Interface(
    fn=pred, 
    inputs=gr.inputs.Image(shape=(224, 224)), 
    outputs=["text", "number", "text"],
    examples=[["example_1.jpg"],
             ["example_2.jpg"],
             ["example_3.jpg"],
             ["example_4.jpg"]],
    theme="default",
    allow_flagging=False

)

iface.launch()
