from diffusers import AutoencoderKL, UNet2DConditionModel, StableDiffusionPipeline, StableDiffusionImg2ImgPipeline, DPMSolverMultistepScheduler
from diffusers import EulerAncestralDiscreteScheduler
import gradio as gr
import torch
import os
from PIL import Image
import datetime
import time
import psutil

from share_btn import community_icon_html, loading_icon_html, share_js

def is_google_colab():
    try:
        import google.colab
        return True
    except:
        return False

is_colab = is_google_colab()
        
start_time = time.time()


if torch.cuda.is_available():
  torchfloat = torch.float16
else:
  torchfloat = torch.float32

class Model:
    def __init__(self, name, path="", prefix=""):
        self.name = name
        self.path = path
        self.prefix = prefix
        self.pipe_t2i = None
        self.pipe_i2i = None


models = [
   Model("Cyberpunk Anime Diffusion", "DGSpitzer/Cyberpunk-Anime-Diffusion", "dgs illustration style "),
   Model("DGSpitzer Art Diffusion", "DGSpitzer/DGSpitzer-Art-Diffusion", "dgspitzer painting,"),
   Model("Guan Yu Diffusion", "DGSpitzer/Guan-Yu-Diffusion", "")
]

custom_model = None
if is_colab:
  models.insert(0, Model("Custom model"))
  custom_model = models[0]

last_mode = "txt2img"
current_model = models[1] if is_colab else models[0]
current_model_path = current_model.path

if is_colab:
  pipe0 = StableDiffusionPipeline.from_pretrained(
      current_model.path,
      torch_dtype=torchfloat,
      scheduler=DPMSolverMultistepScheduler.from_pretrained(current_model.path, subfolder="scheduler"),
      safety_checker=lambda images, clip_input: (images, False)
      )
    
  if torch.cuda.is_available():
    pipe0 = pipe0.to("cuda")

elif torch.cuda.is_available() == False:
  pipe0 = StableDiffusionPipeline.from_pretrained(
    current_model.path,
    torch_dtype=torchfloat,
    scheduler=DPMSolverMultistepScheduler.from_pretrained(current_model.path, subfolder="scheduler")
    )

else:
  eulera = EulerAncestralDiscreteScheduler(beta_start=0.00085, beta_end=0.012, beta_schedule="scaled_linear", num_train_timesteps=1000)
  pipe0 = StableDiffusionPipeline.from_pretrained(
      models[0].path,
      torch_dtype=torchfloat,
      scheduler=eulera
      )
  pipe1 = StableDiffusionPipeline.from_pretrained(
      models[1].path,
      torch_dtype=torchfloat,
      scheduler=eulera,
      use_auth_token=os.environ.get("HF")
      )
#  pipe1 = StableDiffusionPipeline.from_pretrained(
#      models[1].path,
#      torch_dtype=torchfloat,
#      scheduler=eulera
#      )
  pipe2 = StableDiffusionPipeline.from_pretrained(
      models[2].path,
      torch_dtype=torchfloat,
      scheduler=eulera
      )
  if torch.cuda.is_available():
    pipe0 = pipe0.to("cuda")
    pipe1 = pipe1.to("cuda")
    pipe2 = pipe2.to("cuda")
      
  #pipe.enable_xformers_memory_efficient_attention()

device = "GPU 🔥" if torch.cuda.is_available() else "CPU 🥶"

def error_str(error, title="Error"):
    return f"""#### {title}
            {error}"""  if error else ""

def custom_model_changed(path):
  models[0].path = path
  global current_model
  current_model = models[0]

def on_model_change(model_name):
  
  prefix = "Enter prompt. \"" + next((m.prefix for m in models if m.name == model_name), None) + "\" is prefixed automatically" if model_name != models[0].name else "Don't forget to use the custom model prefix in the prompt!"

  return gr.update(visible = model_name == models[0].name), gr.update(placeholder=prefix)

def inference(model_name, prompt, neg_prompt, guidance, steps, width=512, height=512, seed=0, img=None, strength=0.5, n_images=1):
  print("Generated image with prompt: " + prompt)
  if neg_prompt != "":
    print("Negative prompt: " + neg_prompt)
      
  print(psutil.virtual_memory()) # print memory usage

  global current_model
  for model in models:
    if model.name == model_name:
      current_model = model
      model_path = current_model.path

  generator = torch.Generator('cuda').manual_seed(seed) if seed != 0 else None
  
  try:
    if img is not None:
      return img_to_img(model_path, prompt, neg_prompt, img, strength, guidance, steps, width, height, n_images, generator), None, gr.update(visible=True), gr.update(visible=True), gr.update(visible=True)
    else:
      return txt_to_img(model_path, prompt, neg_prompt, guidance, steps, width, height, n_images, generator), None, gr.update(visible=True), gr.update(visible=True), gr.update(visible=True)
  except Exception as e:
    return None, error_str(e), gr.update(visible=False), gr.update(visible=False), gr.update(visible=False)

def inference_example(model_name, prompt, neg_prompt, guidance, steps, width=512, height=512):
    _image, _error, _bool1, _bool2, _bool3 = inference(model_name, prompt, neg_prompt, guidance, steps, width, height)
    return _image


def txt_to_img(model_path, prompt, neg_prompt, guidance, steps, width, height, n_images, generator):

    print(f"{datetime.datetime.now()} txt_to_img, model: {current_model.name}")

    global last_mode
    global pipe0
    global pipe1
    global pipe2
    global current_model_path
    if model_path != current_model_path or last_mode != "txt2img":
        current_model_path = model_path

        if is_colab or current_model == custom_model:
          pipe0 = StableDiffusionPipeline.from_pretrained(
              current_model_path,
              torch_dtype=torchfloat,
              scheduler=DPMSolverMultistepScheduler.from_pretrained(current_model.path, subfolder="scheduler"),
              safety_checker=lambda images, clip_input: (images, False)
              )
          if torch.cuda.is_available():
            pipe0 = pipe0.to("cuda")
            # pipe.enable_xformers_memory_efficient_attention()
        elif torch.cuda.is_available() == False:
          pipe0 = StableDiffusionPipeline.from_pretrained(
            current_model_path,
            torch_dtype=torchfloat,
            scheduler=DPMSolverMultistepScheduler.from_pretrained(current_model.path, subfolder="scheduler")
            )
        last_mode = "txt2img"

    prompt = current_model.prefix + prompt  
    if current_model == models[0] or is_colab or torch.cuda.is_available() == False:
        result = pipe0(
          prompt,
          negative_prompt = neg_prompt,
          num_images_per_prompt=n_images,
          num_inference_steps = int(steps),
          guidance_scale = guidance,
          width = width,
          height = height,
          generator = generator)
    elif current_model == models[1]:
        result = pipe1(
          prompt,
          negative_prompt = neg_prompt,
          num_images_per_prompt=n_images,
          num_inference_steps = int(steps),
          guidance_scale = guidance,
          width = width,
          height = height,
          generator = generator)
    elif current_model == models[2]:
        result = pipe2(
          prompt,
          negative_prompt = neg_prompt,
          num_images_per_prompt=n_images,
          num_inference_steps = int(steps),
          guidance_scale = guidance,
          width = width,
          height = height,
          generator = generator)
    
    print("Job done! Filtering nsfw content")
    
    return replace_nsfw_images(result)

def img_to_img(model_path, prompt, neg_prompt, img, strength, guidance, steps, width, height, n_images, generator):

    print(f"{datetime.datetime.now()} img_to_img, model: {model_path}")

    global last_mode
    global pipe0
    global pipe1
    global current_model_path
    if model_path != current_model_path or last_mode != "img2img":
        current_model_path = model_path

        if is_colab or current_model == custom_model:
          pipe0 = StableDiffusionImg2ImgPipeline.from_pretrained(
              current_model_path,
              torch_dtype=torchfloat,
              scheduler=DPMSolverMultistepScheduler.from_pretrained(current_model.path, subfolder="scheduler"),
              safety_checker=lambda images, clip_input: (images, False)
              )
        else:
          pipe0 = StableDiffusionImg2ImgPipeline.from_pretrained(
              current_model_path,
              torch_dtype=torchfloat,
              scheduler=DPMSolverMultistepScheduler.from_pretrained(current_model.path, subfolder="scheduler")
              )
          # pipe = pipe.to("cpu")
          # pipe = current_model.pipe_i2i
        
        if torch.cuda.is_available():
          pipe0 = pipe0.to("cuda")
          #pipe0.enable_xformers_memory_efficient_attention()
        last_mode = "img2img"

    prompt = current_model.prefix + prompt
    ratio = min(height / img.height, width / img.width)
    img = img.resize((int(img.width * ratio), int(img.height * ratio)), Image.LANCZOS)
    result = pipe0(
        prompt,
        negative_prompt = neg_prompt,
        num_images_per_prompt=n_images,
        image = img,
        num_inference_steps = int(steps),
        strength = strength,
        guidance_scale = guidance,
        # width = width,
        # height = height,
        generator = generator)
        
    return replace_nsfw_images(result)

def replace_nsfw_images(results):
    #Only return 1 image for community sharing
    if is_colab:
      return results.images[0]

    for i in range(len(results.images)):
      if results.nsfw_content_detected[i]:
        results.images[i] = Image.open("nsfw_placeholder.jpg")
          
    return results.images[0]


css = """
#col-container {max-width: 700px; margin-left: auto; margin-right: auto;}
a {text-decoration-line: underline; font-weight: 600;}
.animate-spin {
    animation: spin 1s linear infinite;
}
@keyframes spin {
    from {
        transform: rotate(0deg);
    }
    to {
        transform: rotate(360deg);
    }
}
#share-btn-container {
    display: flex; padding-left: 0.5rem !important; padding-right: 0.5rem !important; background-color: #000000; justify-content: center; align-items: center; border-radius: 9999px !important; width: 13rem;
}
#share-btn {
    all: initial; color: #ffffff;font-weight: 600; cursor:pointer; font-family: 'IBM Plex Sans', sans-serif; margin-left: 0.5rem !important; padding-top: 0.25rem !important; padding-bottom: 0.25rem !important;right:0;
}
#share-btn * {
    all: unset;
}
#share-btn-container div:nth-child(-n+2){
    width: auto !important;
    min-height: 0px !important;
}
#share-btn-container .wrap {
    display: none !important;
}
#gallery{min-height:20rem}
"""

with gr.Blocks(css=css) as demo:
    gr.HTML(
        """
            <div style="text-align: center; max-width: 700px; margin: 0 auto;">
              <div
                style="
                  display: inline-flex;
                  align-items: center;
                  gap: 0.8rem;
                  font-size: 1.75rem;
                "
              >
                <h1 style="font-weight: 900; margin-bottom: 7px;">
                  DGSpitzer Diffusion Space
                </h1>
              </div>
              <p style="margin-bottom: 10px; font-size: 94%">
               Online Demo for <a href="https://huggingface.co/DGSpitzer/Cyberpunk-Anime-Diffusion" target="_blank">Cyberpunk Anime Diffusion</a> & <a href="https://huggingface.co/DGSpitzer/DGSpitzer-Art-Diffusion" target="_blank">DGSpitzer Art Diffusion</a> & <a href="https://huggingface.co/DGSpitzer/Guan-Yu-Diffusion" target="_blank">Guan Yu Diffusion</a>. Based of the projects by anzorq <a href="https://twitter.com/hahahahohohe"></a> and fffiloni <a href="https://twitter.com/fffiloni"></a>
              </p>
            </div>
            <div
               style="
                  gap: 1.2rem;
                  font-size: 1rem;
                "
             >
              <p>Another online version without queue: <a href="https://colab.research.google.com/github/HelixNGC7293/cyberpunk-anime-diffusion/blob/main/cyberpunk_anime_diffusion.ipynb"><img data-canonical-src="https://colab.research.google.com/assets/colab-badge.svg" alt="Open In Colab" src="https://camo.githubusercontent.com/84f0493939e0c4de4e6dbe113251b4bfb5353e57134ffd9fcab6b8714514d4d1/68747470733a2f2f636f6c61622e72657365617263682e676f6f676c652e636f6d2f6173736574732f636f6c61622d62616467652e737667"></a></p>
            </div>
        """
    )
    gr.Markdown('''
      👇 Buy me a coffee if you like ♥ this project!
      [![Buy me a coffee](https://badgen.net/badge/icon/Buy%20Me%20A%20Coffee?icon=buymeacoffee&label)](https://www.buymeacoffee.com/dgspitzer)
    ''')
    with gr.Row():
        
        with gr.Column():
            model_name = gr.Dropdown(label="Model", choices=[m.name for m in models], value=current_model.name)
            #prompt = gr.Textbox(label="Prompt", show_label=False, max_lines=2, placeholder="Enter your prompt~", elem_id="input-prompt").style(container=False)
            prompt = gr.Textbox(label="Prompt", show_label=False, max_lines=2, placeholder="Enter your prompt~", elem_id="input-prompt")
            neg_prompt = gr.Textbox(label="Negative Prompt", placeholder="Enter what you don't want to generate", elem_id="input-neg-prompt")
            width_input = gr.Slider(label="Width", value=576, maximum=768, minimum=384, step=64)
            height_input = gr.Slider(label="Height", value=576, maximum=768, minimum=384, step=64)
            #n_images = gr.Slider(label="Images", value=1, minimum=1, maximum=4, step=1)
            guidance = gr.Slider(label="Guidance scale", value=7, maximum=10)
            steps = gr.Slider(label="Steps", value=20, maximum=50, minimum=2)
            seed = gr.Slider(0, 2147483647, label='Seed (0 = random)', value=0, step=1)
            run = gr.Button(value="Run")
            gr.Markdown(f"Running on: {device}")
            
            # with gr.Column(scale=45):
            #     with gr.Tab("Text to Image"):
            #         with gr.Group():
            #             gr.Markdown(f"Current in text to Image Mode, ")
            #             #seed = gr.Slider(0, 2147483647, label='Seed (0 = random)', value=0, step=1)
                
            #     with gr.Tab("Image to Image"):
            #         with gr.Group():
            #             gr.Markdown(f"Image to Image Mode")
            #             image = gr.Image(label="Image", height=256, tool="editor", type="pil")
            #             strength = gr.Slider(label="Transformation strength", minimum=0, maximum=1, step=0.01, value=0.5)
                      
        with gr.Column():
            image_out = gr.Image(height=512, type="filepath", elem_id="output-img")
            error_output = gr.Markdown()
            #gallery = gr.Gallery(label="Generated images", show_label=False, elem_id="gallery").style(grid=[2], height="auto")
        

    with gr.Column(elem_id="col-container"):
        with gr.Group(elem_id="share-btn-container"):
          community_icon = gr.HTML(community_icon_html, visible=False)
          loading_icon = gr.HTML(loading_icon_html, visible=False)
          share_button = gr.Button("Share to community", elem_id="share-btn", visible=False)
    
    if is_colab:
      model_name.change(on_model_change, inputs=model_name, outputs=[custom_model_group, prompt], queue=False)
      custom_model_path.change(custom_model_changed, inputs=custom_model_path, outputs=None)
    
    #outputs = [gallery, error_output]
    run.click(inference, inputs=[model_name, prompt, neg_prompt, guidance, steps, width_input, height_input, seed], outputs=[image_out, error_output, share_button, community_icon, loading_icon])
    
    share_button.click(None, [], [], _js=share_js)
    
    gr.Examples([
        [models[0].name, "perfect face portrait of beautiful smile girl,  clean face, wears hoody, half body, soldier working in a cyberpunk city, cleavage, intricate, 8k, highly detailed, digital painting, intense, sharp focus", "out of focus, scary, creepy, evil, disfigured, missing limbs, ugly, gross, missing fingers", 7, 20, 512, 704],
        [models[0].name, "portrait of a beautiful fancy gorgeous anime girl, intricate details", "out of focus, scary, creepy, evil, disfigured, missing limbs, ugly, gross, missing fingers", 7, 20, 448, 640],
        [models[0].name, "city landscape with fancy car, racing on the road, gopro, intricate details, 4k, cyberpunk", "out of focus, scary, creepy, evil, disfigured, missing limbs, ugly, gross, missing fingers", 7, 20, 704, 704],
        [models[0].name, "portrait of liu yifei girl, soldier working in a cyberpunk city, cleavage, intricate, 8k, highly detailed, digital painting, intense, sharp focus", "out of focus, scary, creepy, evil, disfigured, missing limbs, ugly, gross, missing fingers", 7, 20, 704, 704],
        [models[0].name, "portrait of a muscular beard male in dgs illustration style, half-body, holding robot arms, strong chest", "out of focus, scary, creepy, evil, disfigured, missing limbs, ugly, gross, missing fingers", 7, 20, 512, 640],
        [models[1].name, "portrait of professional photo of a cute girl, brown hair, freckles, perfect nose, fringe, green eyes, space clothing, space suit, glowing dragon logo on chest, dragon clothes, wearing orange dragon robe, blue dragon belt, dragon pants, dragon cape, action scene, dramatic pose, medium_breasts, perfect face, perfect eyes, pores, soft light,strong body, intricate detail,sharp focus, detailed background, masterpiece, highest quality, 4k, thick thighs, strong legs, tall, High detail RAW color, in spaceship, metal walls, feminine, highly detailed, white neon lights, skin pores, smile, high detail hair, sharp body, detailed body, gorgeous face, realistic, real, fit", "lowres, low quality, twisted,unappealing,uneven,unprofessional,draft,fake face, fake,uneven body, unnatural face, plastic face,out of focus,out of frame, poorly drawn, crippled, crooked, broken, weird, distorted, erased, cut, mutilated, sloppy, ugly, pixelated, bad hands, aliasing, poorly drawn, sloppy, over exposed, over saturated, burnt image, sloppy, fuzzy, poor quality, pixelated, sleepy, closed-eyes, pixelated, ugly, bad anatomy, hideous, deformed, mutant, sloppy, poorly drawn, poorly detailed, smudged, sketch, pencil, doll, plastic, disfigured, close up, topless, nude, naked, cleavage, tits, belly", 7, 30, 576, 576],
        [models[1].name, "professional photo portrait of muscular man male, brown hair, freckles, fringe, brown eyes, space clothing, space suit, glowing UNSC logo on chest, wearing blue astronaut robe, blue space belt, dragon pants, action scene, ", "lowres, low quality, twisted,unappealing,uneven,unprofessional,draft,fake face, fake,uneven body, unnatural face, plastic face,out of focus,out of frame, poorly drawn, crippled, crooked, broken, weird, distorted, erased, cut, mutilated, sloppy, ugly, pixelated, bad hands, aliasing, poorly drawn, sloppy, over exposed, over saturated, burnt image, sloppy, fuzzy, poor quality, pixelated, sleepy, closed-eyes, pixelated, ugly, bad anatomy, hideous, deformed, mutant, sloppy, poorly drawn, poorly detailed, smudged, sketch, pencil, doll, plastic, disfigured, close up, topless, nude, naked, cleavage, tits, belly", 7, 30, 576, 576],
        [models[1].name, "a painting of professional portrait steampunk lady doctor, smart eyes,high-tec huge glasses, very thick dark eyebrow, brown eyes, tan skin, short fancy braid hair, intricate deails, aquiline nose", "cat ear, body out of frame, deformed, blurry, bad anatomy, disfigured, poorly drawn face, mutation, mutated, extra limbs", 7, 30, 576, 576],
        [models[1].name, "a whiteshape professional portrait steampunk fancy bun very short hair girl, gears clothes, heavy armor, masterpiece, 4k, action scene, dramatic pose, small_breasts, perfect face, perfect eyes, pores, soft light,strong body, intricate detail,sharp focus, detailed background, masterpiece, highest quality, 4k, thick thighs, strong legs, tall, High detail RAW color, in spaceship, metal walls, feminine, highly detailed, white neon lights, skin pores, smile, high detail hair, sharp body, detailed body, gorgeous face, realistic, real, fit", "cat ear, body out of frame, deformed, blurry, bad anatomy, ugly, disfigured, poorly drawn face, mutation, mutated, extra limbs", 7, 30, 576, 576],
        [models[1].name, "outline anime portrait of a beautiful martial art girl", "saturation, purple, out of focus, scary, creepy, evil, disfigured, missing limbs, ugly, gross, missing fingers", 7, 30, 576, 576],
        [models[1].name, "a beautiful mech girl, 4k, photorealistic", "saturation", 7, 30, 576, 576],
        [models[1].name, "portrait of a girl, photorealistic painting paladin priest working in a magical tavern, cleavage, perfect face, curvy hair, intricate, 8k, highly detailed, intense, sharp focus, Anime, outline", "lowres, bad anatomy, bad hands, text, error, missing fingers, extra digit, fewer digits, cropped, worst quality, low quality, normal quality, jpeg artifacts, signature, watermark, username, blurry, bad feet", 7, 30, 576, 576],
        [models[1].name, "a mech robot", "purple", 7, 30, 576, 576],
        [models[1].name, "portrait of a beautiful very young teen cowboy girl who embodies the rugged and independent spirit of the Old West. She should be strong-willed and confident, with a sharp sense of justice and a heart of gold. Her style should be a blend of traditional Western fashion and modern flair, with a touch of glamour and femininity. Whether she's taming wild horses, fighting off bandits, or just enjoying the sunset on the prairie, this cowboy girl is a force to be reckoned with and a sight to behold.", "lowres, bad anatomy, bad hands, text, error, missing fingers, extra digit, fewer digits, cropped, worst quality, low quality, normal quality, jpeg artifacts, signature, watermark, username, blurry, bad feet", 7, 30, 576, 576],
        [models[1].name, "a muscular man from space", "blurry, out of focus", 7, 30, 576, 576],
        [models[1].name, "landscape of a cyberpunk soldier man in the battlefield, dark light, far away", "blurry, out of focus", 7, 30, 704, 576],
        [models[2].name, "Portrait of guanyu walking in ancient battlefield, close up shot", "blurry, out of focus, scary, creepy, evil, disfigured, missing limbs, ugly, gross, missing fingers", 7, 30, 576, 576],
        [models[2].name, "Portrait of a man holding very cute panda plushie, Guanyu", "", 7, 30, 576, 576],
        [models[2].name, "taking selfie on ancient battlefield of China, guanyu, gopro, sharp focus, old scratched photo, three kingdoms warriors everywhere, masterpiece", "blurry, out of focus, scary, creepy, evil, disfigured, missing limbs, ugly, gross, missing fingers", 7, 30, 576, 576],
        [models[2].name, "superman, portrait of fancy superhero guanyu, golden spiderman, mech, robot, high tech, shining core, intricate details, 4k", "blurry, out of focus, scary, creepy, evil, disfigured, missing limbs, ugly, gross, missing fingers", 7, 30, 576, 576],
        [models[2].name, "batman, portrait of fancy superhero guanyu, golden spiderman, mech, robot, high tech, shining core, intricate details, 4k", "blurry, out of focus, scary, creepy, evil, disfigured, missing limbs, ugly, gross, missing fingers", 7, 30, 576, 576],
        [models[2].name, "a huge gundam mech fighting against guanyu", "blurry, out of focus", 7, 30, 576, 576],
        [models[2].name, "a cute nendoroid figure toy guanyu", "blurry, out of focus, scary, creepy, evil, disfigured, missing limbs, ugly, gross, missing fingers", 7, 30, 576, 576],
        [models[2].name, "a cute funko figure toy guanyu", "blurry, out of focus, scary, creepy, evil, disfigured, missing limbs, ugly, gross, missing fingers", 7, 30, 576, 576],
        [models[2].name, "a lego guanyu", "blurry, out of focus, scary, creepy, evil, disfigured, missing limbs, ugly, gross, missing fingers", 7, 30, 576, 576],
        [models[2].name, "a gorgeous wuxia girl standing in the palace", "blurry, out of focus, scary, creepy, evil, disfigured, missing limbs, ugly, gross, missing fingers", 7, 30, 576, 576],
        [models[2].name, "a handsome wuxia man", "blurry, out of focus, scary, creepy, evil, disfigured, missing limbs, ugly, gross, missing fingers", 7, 30, 576, 576],
        [models[2].name, "a wuxia girl diving underwater, surrounded by a shark", "blurry, out of focus, scary, creepy, evil, disfigured, missing limbs, ugly, gross, missing fingers", 7, 20, 576, 576],
        [models[2].name, "a cute nendoroid wuxia figure toy", "blurry, out of focus, scary, creepy, evil, disfigured, missing limbs, ugly, gross, missing fingers", 7, 30, 576, 576],
    ], [model_name, prompt, neg_prompt, guidance, steps, width_input, height_input], outputs=image_out, fn=inference_example, cache_examples=torch.cuda.is_available())
    gr.Markdown('''
      Models and Space by [@DGSpitzer](https://www.youtube.com/channel/UCzzsYBF4qwtMwJaPJZ5SuPg)❤️ [@大谷的游戏创作小屋](https://space.bilibili.com/176003)
      [![Twitter Follow](https://img.shields.io/twitter/follow/DGSpitzer?label=%40DGSpitzer&style=social)](https://twitter.com/DGSpitzer)
      ![visitors](https://visitor-badge.glitch.me/badge?page_id=dgspitzer_DGS_Diffusion_Space)
      
      ![Model Views](https://visitor-badge.glitch.me/badge?page_id=DGspitzer_Art_Diffusion)
      
    ''')

if not is_colab:
  demo.queue(concurrency_count=1)
demo.launch(debug=is_colab, share=is_colab)