from gchar.games.dispatch.access import GAME_CHARS


def try_find_title(char_name, game_name):
    try:
        game_cls = GAME_CHARS[game_name.lower()]
        ch = game_cls.get(char_name)
        if ch:
            names = []
            if ch.enname:
                names.append(str(ch.enname))
            if ch.jpname:
                names.append(str(ch.jpname))
            if ch.cnname:
                names.append(str(ch.cnname))
            if hasattr(ch, 'krname') and ch.krname:
                names.append(str(ch.krname))

            return f"{'/'.join(names)} ({game_cls.__official_name__})"

        else:
            cname = ' '.join(list(map(str.capitalize, char_name.split(' '))))
            return f'{cname} ({game_cls.__official_name__})'

    except KeyError:
        return None
