import sklearn
import sqlite3
import numpy as np
from sklearn.metrics.pairwise import cosine_similarity
import openai
import os
import gradio as gr


openai.api_key = os.environ["Secret"] 

def find_closest_neighbors(vector1, dictionary_of_vectors):
    """
    Takes a vector and a dictionary of vectors and returns the three closest neighbors
    """
    vector = openai.Embedding.create(
        input=vector1,
        engine="text-embedding-ada-002"
    )['data'][0]['embedding']

    vector = np.array(vector)

    cosine_similarities = {}
    for key, value in dictionary_of_vectors.items():
        cosine_similarities[key] = cosine_similarity(vector.reshape(1, -1), value.reshape(1, -1))[0][0]

    sorted_cosine_similarities = sorted(cosine_similarities.items(), key=lambda x: x[1], reverse=True)
    match_list = sorted_cosine_similarities[0:4]

    return match_list

def predict(message, history):
    # Connect to the database
    conn = sqlite3.connect('QRIdatabase7.db')
    cursor = conn.cursor()
    cursor.execute('''SELECT text, embedding FROM chunks''')
    rows = cursor.fetchall()

    dictionary_of_vectors = {}
    for row in rows:
        text = row[0]
        embedding_str = row[1]
        embedding = np.fromstring(embedding_str, sep=' ')
        dictionary_of_vectors[text] = embedding
    conn.close()

    # Find the closest neighbors
    match_list = find_closest_neighbors(message, dictionary_of_vectors)
    context = ''
    for match in match_list:
        context += str(match[0])
    context = context[:-1500]

    prep = f"This is an OpenAI model tuned to answer questions specific to the Qualia Research institute, a research institute that focuses on consciousness. Here is some question-specific context, and then the Question to answer, related to consciousness, the human experience, and phenomenology: {context}. Here is a question specific to QRI and consciousness in general Q:  {message}  A: "

    history_openai_format = []
    for human, assistant in history:
        history_openai_format.append({"role": "user", "content": human })
        history_openai_format.append({"role": "assistant", "content":assistant})
    history_openai_format.append({"role": "user", "content": prep})

    response = openai.ChatCompletion.create(
        model='gpt-3.5-turbo',
        messages= history_openai_format,         
        temperature=1.0,
        stream=True
    )
    
    partial_message = ""
    for chunk in response:
        if len(chunk['choices'][0]['delta']) != 0:
            partial_message = partial_message + chunk['choices'][0]['delta']['content']
            yield partial_message 

demo = gr.ChatInterface(predict).queue()

if __name__ == "__main__":
    demo.launch()
