import io
import os
import warnings

from PIL import Image
from stability_sdk import client
import stability_sdk.interfaces.gooseai.generation.generation_pb2 as generation

import gradio as gr
stability_api = client.StabilityInference(
    key=os.environ["Secret"], 
    verbose=True,
)


def infer(prompt):
  # the object returned is a python generator
  answers = stability_api.generate(
      prompt=f"Beautiful Portait of a {prompt} made out of flowers 💐 🌺 🌸 , artstation winner by Victo Ngai, Kilian Eng, vibrant colors, winning-award masterpiece, aesthetic octane render, 8K HD",
      height =640
  )
  
  # iterating over the generator produces the api response
  for resp in answers:
      for artifact in resp.artifacts:
          if artifact.finish_reason == generation.FILTER:
              warnings.warn(
                  "Your request activated the API's safety filters and could not be processed."
                  "Please modify the prompt and try again.")
          if artifact.type == generation.ARTIFACT_IMAGE:
              img = Image.open(io.BytesIO(artifact.binary))
              return img


block = gr.Blocks(css=".container { max-width: 600px; margin: auto; }")

num_samples = 1



with block as demo:
    gr.Markdown("<h1><center>Flower Diffusion</center></h1>")
    gr.Markdown(
        "Get a pretty flowery image from any prompt - keep it simple!"
    )
    with gr.Group():
        with gr.Box():
            with gr.Row().style(mobile_collapse=False, equal_height=True):

                text = gr.Textbox(
                value = "Kitty cat",
                    label="Enter your prompt", show_label=False, max_lines=1
                ).style(
                    border=(True, False, True, True),
                    rounded=(True, False, False, True),
                    container=False,
                )
                btn = gr.Button("Run").style(
                    margin=False,
                    rounded=(False, True, True, False),
                )
        
               
        gallery = gr.Image()
        text.submit(infer, inputs=[text], outputs=gallery)
        btn.click(infer, inputs=[text], outputs=gallery)

   
    


demo.launch(debug=True, enable_queue = True)