import gradio as gr
import cv2
import numpy as np
import shutil
from bs4 import BeautifulSoup
import requests
import pandas as pd

from SEM.run_single_sem import run_single_pp
from CDM.run_single import run_single_img

title = "Cpp4App"
description = "Automated Contextual Privacy Policies Generation for Mobile Apps"


def write_and_read():
    # Write
    with open('myfile.txt', 'w') as f:
        f.write('Hello, World!')

    # Read
    with open('myfile.txt', 'r') as f:
        data = f.read()

    print("this is data: ", data)

    return data

def run_demo(img_root, output_root, segment_root, file):
    print(type(file))

    # file_content = file.read().decode('utf-8')
    run_single_pp(file)

    output_board, output_data, complete_result = run_single_img(img_root, output_root, segment_root)

    return output_board, output_data, complete_result

def inference(img, html):

    write_and_read()

    if img is None or html is None:
        return None, None

    output_root = "./CDM/result_classification"
    segment_root = './SEM/txt'
    img_root = "./CDM/input_examples/1-1-write.jpg"
    pp_root = "1.txt"

    # output_root = ""
    # segment_root = ""
    # img_root = "demo_img.jpg"

    img_array = np.array(img)

    cv2.imwrite(img_root, img_array)

    # replace example string with real example
    # if html == 'html content 1':
    #     with open("examples/6.txt", "r") as f:
    #         html = f.read()
    # elif html == 'html content 2':
    #     with open("examples/11.txt", "r") as f:
    #         html = f.read()

    # print("string: ", html)
    # with open(pp_root, 'w', encoding='utf-8') as file:  # Open the destination file in text mode
    #     file.write(html)  # Write the HTML content to the destination file

    try:
        response = requests.get(html)
        response.raise_for_status()  # Will raise an exception if the status is an error
        input_text = response.text
    except requests.HTTPError:
        input_text = ""
    # print("input_text: ", input_text)
    with open(pp_root, 'w', encoding='utf-8') as file:
        file.write(input_text)

    soup = BeautifulSoup(open(pp_root, encoding='utf-8'), features="html.parser")
    # print("pp_root soup: ", soup.contents)

    output_board, output_data, complete_result = run_demo(img_root, output_root, segment_root, pp_root)

    # print(output_data)

    return output_board, output_data, complete_result

# inputs = [
#     gr.inputs.Image(type="pil", label="Image Upload"),
#     # gr.inputs.File(label="HTML File Upload"),
#     gr.inputs.Textbox(label="Text Input")
#     # gr.inputs.Textbox(lines=True, label="HTML Text")
# ]
# output = [
#     gr.outputs.Image(type="pil", label="Result Image"),
#     gr.outputs.Dataframe(type="pandas", label="Result Excel")
# ]

# gr.Interface(
#     inference,
#     # inputs,
#     # output,
#     inputs=[image_input_row, textbox_input_row],
#     outputs=[image_output_row, dataframe_output_row],
#     title=title,
#     description=description,
#     # examples=[['examples/6-8.jpg', 'examples/6.txt'], ['examples/11-9.jpg', 'examples/11.html']],
#     # examples=[['examples/6-8.jpg', example_file_content_1], ['examples/11-9.jpg', example_file_content_2]],
#     examples=[['examples/6-8.jpg', 'html content 1'], ['examples/11-9.jpg', 'html content 2']],
#     enable_queue=True,
#     capture_session=True,
#     layout='vertical'
# ).launch(debug=False)

# def example_inference():
#     image_input_bgr = cv2.imread('examples/6-8.jpg')
#     image_input = cv2.cvtColor(image_input_bgr, cv2.COLOR_BGR2RGB)
#     # text_input = 'html content 1' # example string
#     text_input = 'https://www.whatsapp.com/legal/privacy-policy'
#
#     out_result, out_segment = inference(image_input, text_input)
#
#     return image_input, text_input, out_result, out_segment

def example_inference_1():
    image_input_bgr = cv2.imread("examples/6-8.jpg")
    image_input = cv2.cvtColor(image_input_bgr, cv2.COLOR_BGR2RGB)
    text_input = 'https://www.whatsapp.com/legal/privacy-policy'
    out_result, out_segment, complete_result = inference(image_input, text_input)
    return image_input, text_input, out_result, out_segment, complete_result

def example_inference_2():
    image_input_bgr = cv2.imread("examples/11-9.jpg")
    image_input = cv2.cvtColor(image_input_bgr, cv2.COLOR_BGR2RGB)
    text_input = 'https://values.snap.com/privacy/privacy-policy'
    out_result, out_segment, complete_result = inference(image_input, text_input)
    return image_input, text_input, out_result, out_segment, complete_result

def example_inference_3():
    image_input_bgr = cv2.imread("examples/1-1.jpg")
    image_input = cv2.cvtColor(image_input_bgr, cv2.COLOR_BGR2RGB)
    text_input = 'https://mcdonalds.com.au/privacy-policy'
    out_result, out_segment, complete_result = inference(image_input, text_input)
    return image_input, text_input, out_result, out_segment, complete_result

def new_example_inference_1():
    image_input_bgr = cv2.imread("examples/6-8.jpg")
    image_input = cv2.cvtColor(image_input_bgr, cv2.COLOR_BGR2RGB)
    text_input = 'https://www.whatsapp.com/legal/privacy-policy'

    out_result_bgr = cv2.imread("results/result_1.png")
    out_result = cv2.cvtColor(out_result_bgr, cv2.COLOR_BGR2RGB)

    out_segment = pd.read_excel("results/result_1_S.xlsx")
    complete_result = pd.read_excel("results/result_1_C.xlsx")

    return image_input, text_input, out_result, out_segment, complete_result

def new_example_inference_2():
    image_input_bgr = cv2.imread("examples/11-9.jpg")
    image_input = cv2.cvtColor(image_input_bgr, cv2.COLOR_BGR2RGB)
    text_input = 'https://values.snap.com/privacy/privacy-policy'

    out_result_bgr = cv2.imread("results/result_2.png")
    out_result = cv2.cvtColor(out_result_bgr, cv2.COLOR_BGR2RGB)

    out_segment = pd.read_excel("results/result_2_S.xlsx")
    complete_result = pd.read_excel("results/result_2_C.xlsx")

    return image_input, text_input, out_result, out_segment, complete_result

def new_example_inference_3():
    image_input_bgr = cv2.imread("examples/1-1.jpg")
    image_input = cv2.cvtColor(image_input_bgr, cv2.COLOR_BGR2RGB)
    text_input = 'https://mcdonalds.com.au/privacy-policy'

    out_result_bgr = cv2.imread("results/result_3.png")
    out_result = cv2.cvtColor(out_result_bgr, cv2.COLOR_BGR2RGB)

    out_segment = pd.read_excel("results/result_3_S.xlsx")
    complete_result = pd.read_excel("results/result_3_C.xlsx")

    return image_input, text_input, out_result, out_segment, complete_result

# def toggle_dataframe_callback():
#     complete_result_dataframe.visible = not complete_result_dataframe.visible

demo = gr.Blocks()
with demo:
    gr.Markdown("# Cpp4App\n\n**Automated Contextual Privacy Policies Generation for Mobile Apps**"
                "\n\nThere are two inputs to generate CPP for a mobile app: app's privacy policy URL link and a GUI screenshot")

    with gr.Row():
        example_image_1 = gr.Image(value="examples/6-8.jpg", label="Example 1")
        example_image_2 = gr.Image(value="examples/11-9.jpg", label="Example 2")
        example_image_3 = gr.Image(value="examples/1-1.jpg", label="Example 3")
        with gr.Column():
            gr.Markdown("**You can try with three examples we provided:**"
                        "\n\n- WhatsApp"
                        "\n\n- Snap"
                        "\n\n- Mcdonald's"
                        "\n\n**You can also try with your own example:**"
                        "\n\nUpload the screenshot and privacy policy URL link, then click 'submit' button"
                        # "\n\n"
                        # "\n\nThe three provided examples are pre-run, while your own screenshot needs to run for approximately one minute."
                        )

    with gr.Row():
        example_button_1 = gr.Button("Run with Example 1")
        example_button_2 = gr.Button("Run with Example 2")
        example_button_3 = gr.Button("Run with Example 3")
        with gr.Column():
            clear_button = gr.Button("Clear")
            submit_button = gr.Button("Submit")

    with gr.Row():
        text_input = gr.inputs.Textbox(label="URL Input for the Privacy Policy of the App")

        with gr.Column():
            image_input = gr.inputs.Image(type="pil", label="Screenshot Upload")
        result_image = gr.outputs.Image(type="pil", label="Result Screenshot")

    with gr.Row():
        result_dataframe = gr.outputs.Dataframe(type="pandas", label="Result Excel (Summarized)")

    # with gr.Row():
    #     # Create a button to control the display of complete_result_dataframe
    #     toggle_dataframe_button = gr.Button("Show Complete Result Excel")

    with gr.Row():
        complete_result_dataframe = gr.outputs.Dataframe(type="pandas", label="Result Excel (Complete)")

    # with gr.Row():
    #     example_button_1 = gr.Button("Run with Example 1")
    #     example_button_2 = gr.Button("Run with Example 2")
    #     example_button_3 = gr.Button("Run with Example 3")
    #     with gr.Column():
    #         clear_button = gr.Button("Clear")
    #         submit_button = gr.Button("Submit")
    #
    # with gr.Row():
    #     example_image_1 = gr.Image(value="examples/6-8.jpg", label="Example 1")
    #     example_image_2 = gr.Image(value="examples/11-9.jpg", label="Example 2")
    #     example_image_3 = gr.Image(value="examples/1-1.jpg", label="Example 3")
    #     with gr.Column():
    #         gr.Markdown("**You can try with three examples we provided:**"
    #                     "\n\n- WhatsApp"
    #                     "\n\n- Snap"
    #                     "\n\n- Mcdonald's"
    #                     "\n\n**You can also try with your own example:**"
    #                     "\n\nUpload the screenshot and privacy policy URL link, then click 'submit' button")

    submit_button.click(inference, inputs=[image_input, text_input], outputs=[result_image, result_dataframe, complete_result_dataframe])
    clear_button.click(lambda: [None, None, None, None, None, None], inputs=[], outputs=[image_input, text_input, result_image, result_dataframe, complete_result_dataframe])
    # example_button.click(example_inference, inputs=[], outputs=[image_input, text_input, result_image, result_dataframe])
    example_button_1.click(new_example_inference_1,
                           inputs=[],
                           outputs=[image_input, text_input, result_image, result_dataframe, complete_result_dataframe])
    example_button_2.click(new_example_inference_2,
                           inputs=[],
                           outputs=[image_input, text_input, result_image, result_dataframe, complete_result_dataframe])
    example_button_3.click(new_example_inference_3,
                           inputs=[],
                           outputs=[image_input, text_input, result_image, result_dataframe, complete_result_dataframe])

    # # Create a unique CSS ID for the dataframe output
    # dataframe_id = id(complete_result_dataframe)
    #
    # # Define CSS styles for hiding/showing the dataframe
    # hide_style = f"#{dataframe_id} {{ display: none; }}"
    # show_style = f"#{dataframe_id} {{ display: block; }}"
    #
    #
    # def toggle_dataframe_callback():
    #     if toggle_dataframe_button.label == "Show Complete Result Excel":
    #         toggle_dataframe_button.label = "Hide Complete Result Excel"
    #         gr.Html(style=show_style).show()
    #     else:
    #         toggle_dataframe_button.label = "Show Complete Result Excel"
    #         gr.Html(style=hide_style).show()

demo.launch()
