# AUTOGENERATED! DO NOT EDIT! File to edit: app.ipynb.

# %% auto 0
__all__ = ['temp', 'learn', 'categories', 'image', 'label', 'examples', 'intf', 'is_cat', 'classify_image']

# %% app.ipynb 1
from fastai.vision.all import *
import gradio as gr

# %% app.ipynb 2
def is_cat(x):
    return x[0].isupper()

learn = load_learner('model.pkl')

# %% app.ipynb 5
categories = ('Dog', 'Cat')

def classify_image(img):
    pred, idx, probs = learn.predict(img)
    return dict(zip(categories, map(float, probs)))

# %% app.ipynb 8
image = gr.Image(shape=(192, 192))
label = gr.Label()
examples = ['dog.png', 'cat.png']

intf = gr.Interface(fn=classify_image,
                    inputs=image,
                    outputs=label,
                    examples=examples)
intf.launch(inline=False)
