---
title: CornSnakeMorphID
emoji: 🌽🐍
colorFrom: orange
colorTo: yellow
sdk: gradio
sdk_version: 3.18.0
app_file: app.py
pinned: false
---

# Corn Snake Morph ID
I've seen a lot of posts in [r/cornsnakes](https://www.reddit.com/r/cornsnakes/) asking what morph their pet Corn Snake is. For those who don't know, a morph is the genetic coloring or pattern that shows up in the snake. Common traits include:
* Amel (amelanistic): Lack of melanin or black pigment around the saddles (dark splotches) on the snake's back or in it's eyes.
* Blooodred (diffused): Low or no contrast througout the pattern of of the snake's back. The belly will often be white with no checkers.
* Stripe: Striped back, often white belly.

## Inference
The model runs on square images of 224x224 resolution. This space will automatically resize the image, but it is reccomended you use the build-in tool to crop to a square.
Tips for accuracy:
* High contrast from background. The snake should stick out.
* Coiled or wrapped snakes. Streched out snakes spead out the patterns, lowering accuracy.
* Include a snake face if possible.
* Use natural light with good white balance, no red lights or extreme lighting.

Photos on hands work, because a lot of the training set included pictures like that. You should run the model multiple times on different pictures and lighting so ensure the results are accurate.
**This model is a guide to help you begin research**. You should look up pictures and traits of the classified morph to be 100% sure. Not all genes, ages, or variations are represented in this model.

## Model Description
This model is based on the Vision Transformer (ViT) which is a transformer encoder model (BERT-like) pretrained on a large collection of images in a supervised fashion, namely ImageNet-21k, at a resolution of 224x224 pixels.
The model was set to multilabel mode, allowing it to classify multiple genes at once, however it only sometimes works. See more details at the (original model page)[https://huggingface.co/google/vit-base-patch16-224-in21k].

## Bias
Many of the dataset images were young snakes, usually less that 2 years old. Because markings will sometime change as a snake ages, the model works better on young snakes. Some mutuations such as Sunkissed and Amel/Hypomelanistic are so common that the model predicts those at a much higher rate. Some grey genes like Cinder and Charcoal are often confused, due to the similarity.

## Dataset
This model was trained on photo submitted to [r/Cornsnake_Pics](https://www.reddit.com/r/Cornsnake_Pics/), along with the post flairs, augmented with random rotations and hue shifts. The original data containes 5k center cropped images at 512x512 (resized to 224x224 for this model). The augmented data had 3 augmented copies for each image, resulting in about 21k images.

## How to use
Here is how to use this model in PyTorch:
```
import torch
from transformers import ViTForImageClassification, ViTImageProcessor
from PIL import Image
import requests

url = 'http://images.cocodataset.org/val2017/000000039769.jpg'
image = Image.open(requests.get(url, stream=True).raw)


classes = ['amel', 'cinder', 'sunkissed', 'anery', 'motley', 'toffee', 'bloodred', 'tessera', 'caramel', 'charcoal',
           'coral', 'snow', 'fire', 'ghost', 'ultramel', 'stripe', 'hypo', 'kastanie', 'hypomelanistic', 'lava',
           'lavender', 'miami', 'honey', 'wild-type', 'palmetto', 'salmon', 'diffused']

model = ViTForImageClassification.from_pretrained("IfanSnek/CornSnakes", num_labels=len(classes),
                                                  problem_type="multi_label_classification")
model = ViTModel.from_pretrained('IfanSnek/CornSnakes')
inputs = feature_extractor(images=image, return_tensors="pt")

outputs = model(**inputs)
probs = torch.sigmoid(outputs.logits)[0]
predictions = {}
for i, prob in enumerate(probs[0]):
    predictions[classes[i]] = prob.item()
```