from transformers import AutoModelForCausalLM, AutoTokenizer, AutoModelForSeq2SeqLM, T5ForConditionalGeneration, T5Tokenizer
tokenizer = AutoTokenizer.from_pretrained("microsoft/DialoGPT-large")
model = AutoModelForCausalLM.from_pretrained("microsoft/DialoGPT-large")
grammar_tokenizer = T5Tokenizer.from_pretrained('deep-learning-analytics/GrammarCorrector')
grammar_model = T5ForConditionalGeneration.from_pretrained('deep-learning-analytics/GrammarCorrector')
import torch
import gradio as gr



def chat(message, history=[]):
    new_user_input_ids = tokenizer.encode(message+tokenizer.eos_token, return_tensors='pt')
    if  len(history) > 0:
        last_set_of_ids = history[len(history)-1][2]
        bot_input_ids = torch.cat([last_set_of_ids, new_user_input_ids], dim=-1) 
    else:
        bot_input_ids = new_user_input_ids
    chat_history_ids = model.generate(bot_input_ids, max_length=5000, pad_token_id=tokenizer.eos_token_id)
    response_ids = chat_history_ids[:, bot_input_ids.shape[-1]:][0]
    response = tokenizer.decode(response_ids, skip_special_tokens=True)
    history.append((message, response, chat_history_ids))
    return history, history, feedback(message)


def feedback(text):
    num_return_sequences=1
    batch =  grammar_tokenizer([text],truncation=True,padding='max_length',max_length=64, return_tensors="pt")
    corrections = grammar_model.generate(**batch,max_length=64,num_beams=2, num_return_sequences=num_return_sequences, temperature=1.5)
    corrected_text = grammar_tokenizer.decode(corrections[0], clean_up_tokenization_spaces=True, skip_special_tokens=True)
    print("The corrected text is: ", corrected_text)
    print("The orig text is: ", text)
    if corrected_text.rstrip('.') == text.rstrip('.'):
    # if corrected_text == text:
        feedback = f'Looks good! Keep up the good work'
    else:
        feedback = f'\'{corrected_text}\' might be a little better'
    return feedback


title = "A chatbot that provides grammar feedback"
description = "A quick proof of concept using Gradio"
article = "<p style='text-align: center'><a href='https://docs.google.com/presentation/d/11fiO91MKZVgNoQJh5pn3Tw8-inHe6XbWYB2r1f701WI/edit?usp=sharing'> A conversational agent for Language learning</a> | <a href='https://github.com/ConorNugent/gradio-chatbot-demo'>Github Repo</a></p>"
examples = [
            ["Have you read the play what I wrote?"],
            ["Were do you live?"],
]

iface = gr.Interface(
    chat,
    [gr.Textbox(label="Send messages here"), "state"],
    [gr.Chatbot(label='Conversation'), "state", gr.Textbox(
            label="Feedback",
            lines=1
        )],
    allow_screenshot=False,
    allow_flagging="never",
    title=title, 
    description=description, 
    article=article, 
    examples=examples)
iface.launch()
