import comet_ml


def start_experiment(
    comet_api_key,
    comet_workspace,
    comet_project_name,
    comet_experiment_name,
    experiment,
):
    if comet_api_key is None:
        experiment = None
        return (
            experiment,
            """
            Please add your API key in order to log your predictions to a Comet Experiment.
            If you don't have a Comet account yet, you can sign up using the link below:

            https://www.comet.ml/signup
            """,
        )

    try:
        if comet_experiment_name:
            # Retrieve the Experiment if it already exists
            api_experiment = get_experiment(
                {
                    "api_key": comet_api_key,
                    "workspace": comet_workspace,
                    "project_name": comet_project_name,
                    "experiment": comet_experiment_name,
                }
            )
        else:
            # Create a new Experiment
            api_experiment = comet_ml.APIExperiment(
                api_key=comet_api_key,
                workspace=comet_workspace,
                project_name=comet_project_name,
            )
            api_experiment.log_other("Created from", "Spaces")

        experiment = {
            "api_key": comet_api_key,
            "workspace": comet_workspace,
            "project_name": comet_project_name,
            "experiment": api_experiment.name,
        }

        return experiment, f"Started {api_experiment.name}. Happy logging!😊"

    except Exception as e:
        return None, e


def get_experiment(experiment_state):
    try:
        api_key = experiment_state.get("api_key")
        workspace = experiment_state.get("workspace")
        project = experiment_state.get("project_name")
        experiment_name = experiment_state.get("experiment")

        return comet_ml.API(api_key=api_key).get_experiment(
            workspace=workspace, project_name=project, experiment=experiment_name
        )
    except Exception as e:
        return None


def get_experiment_status(experiment_state):
    experiment = get_experiment(experiment_state)
    if experiment is not None:
        name = experiment.name
        return experiment_state, f"Currently logging to: {name}"

    return experiment_state, f"No Experiments found"
