import gradio as gr
from fastai.vision.all import *

def which_player(x): return x[0].isupper()

learn = load_learner('model.pkl')

categories = learn.dls.vocab

def classify_image(img):
    pred, ids, probs = learn.predict(img)
    return dict(zip(categories, map(float, probs)))

image = gr.inputs.Image(shape=(192, 192))
label = gr.outputs.Label()
examples = ['kevin_durant_nets-scaled.jpeg', 'kyrieirving.jpg', 'kawhileonard.jpg', 'bensimmons.jpg', 'zachlavine.jpg']

iface = gr.Interface(fn=classify_image, inputs=image, outputs=label, examples=examples)
iface.launch(inline=False)