import gradio as gr


# -*- coding: utf-8 -*-

import cv2
import numpy as np
import tensorflow.compat.v1 as tf
tf.disable_v2_behavior()



import imutils
import dlib
from facealigner import FaceAligner
from imutils.face_utils import rect_to_bb
from imutils import face_utils

#-------------------------------start facial preprocessing------------------------------
detector_size = 512

# construct the arguments; shape-predictor & image
shape_predictor = 'shape_predictor_68_face_landmarks.dat'

#initialize dlib's face detector (HOG-based) and then create
# the facial landmark predictor and the face aligner
detector = dlib.get_frontal_face_detector()
predictor = dlib.shape_predictor(shape_predictor)
fa = FaceAligner(predictor, desiredFaceWidth=detector_size) 


def face_preprocessing(image_src):#,save_name):

    image_resized = imutils.resize(image_src, width=768)   
    gray = cv2.cvtColor(image_resized, cv2.COLOR_BGR2GRAY)
    rects = detector(gray, 2)
    if len(rects) == 0:
        print('no face detected')
        return image_src, 0
    rect = rects[0]
    #print(image_resized.shape, gray.shape, rect)
    img = fa.align(image_resized, gray, rect)
    #print(img.shape)
    #exit(0)
    gray2 = img.copy() 
    rects2 = detector(gray2, 2)  #########
    if len(rects2) == 0:
        print('no face detected after alignment')
        return img, 0
    rect = rects2[0]

    lm = predictor(gray2, rect)  
    lm = face_utils.shape_to_np(lm)

    n_size=img.shape[0]
    landmarks_points=[]
    for n in range(0,17):
        if n == 0:
            x = 0
            y = 0
        elif n == 16:
            x=n_size
            y=0
        else:
            x=lm[n][0]
            y=lm[n][1]

        landmarks_points.append((x,y))
    #print(landmarks_points)
    #exit(0)
    target_gray=cv2.cvtColor(img,cv2.COLOR_RGB2GRAY)
    mask=np.zeros_like(target_gray)
    points=np.array(landmarks_points,np.int32)
    
    convexhull=cv2.convexHull(points)
    
    cv2.fillConvexPoly(mask,convexhull,255)

    target_face_1=cv2.bitwise_and(img,img,mask=mask)

    left = lm[0]
    right = lm[16]
    top = lm[20]
    nosetip = lm[30]
    jaw = lm[8]
    n=60
    #print(left)
    #print(2*(left[0]-n)-(1024-jaw[1]),jaw[1],left[0]-n,1024-(left[0]-n))
    if left[0]-n >= detector_size-(left[0]-n) or left[0]-n > detector_size-(left[0]-n):
        print('not cropped')
        return img, 1
    img_crop = target_face_1[left[0]-n:detector_size-(left[0]-n),left[0]-n:detector_size-(left[0]-n)]
    #mg_crop = img[ 2*(left[0]-n)-(1024-jaw[1]):jaw[1],left[0]-n:1024-(left[0]-n)]
    return img_crop, 1



#----------------------------end facial preprocessing------------






batch_size = 1
w,h=200,200
ch=3

# -----------------build networks----------------------

x = tf.placeholder(tf.float32, shape=[batch_size, w, h, ch], name='x')
y_ = tf.placeholder(tf.float32, shape=[batch_size, 1], name='y_')
y_event = tf.placeholder(tf.float32, shape=[batch_size, 1], name='y_event')
y_ = tf.transpose(y_)
y_mask = tf.placeholder(tf.float32, shape=[batch_size, batch_size], name='y_mask')
y_true = tf.concat ([y_, y_mask], axis = 0)
y_true=tf.transpose(y_true)
print(tf.shape(y_true))


# conv1
conv1 = tf.layers.conv2d(inputs=x, filters=32, kernel_size=[5, 5], padding="same", activation=tf.nn.relu,
                         kernel_initializer=tf.truncated_normal_initializer(stddev=0.01))
pool1 = tf.layers.max_pooling2d(inputs=conv1, pool_size=[2, 2], strides=2)

# conv2
conv2 = tf.layers.conv2d(inputs=pool1, filters=64, kernel_size=[5, 5], padding="same", activation=tf.nn.relu,
                         kernel_initializer=tf.truncated_normal_initializer(stddev=0.01))
pool2 = tf.layers.max_pooling2d(inputs=conv2, pool_size=[2, 2], strides=2)

# conv3
conv3 = tf.layers.conv2d(inputs=pool2, filters=128, kernel_size=[3, 3], padding="same", activation=tf.nn.relu,
                         kernel_initializer=tf.truncated_normal_initializer(stddev=0.01))
pool3 = tf.layers.max_pooling2d(inputs=conv3, pool_size=[2, 2], strides=2)

# conv4
conv4 = tf.layers.conv2d(inputs=pool3, filters=256, kernel_size=[3, 3], padding="same", activation=tf.nn.relu,
                         kernel_initializer=tf.truncated_normal_initializer(stddev=0.01))
pool4 = tf.layers.max_pooling2d(inputs=conv4, pool_size=[2, 2], strides=2)

re1 = tf.reshape(pool4, [-1, 12 * 12 * 256])

# fully connected 
dense1 = tf.layers.dense(inputs=re1, units=1024, activation=tf.nn.relu,
                         kernel_initializer=tf.truncated_normal_initializer(stddev=0.01))
dense2 = tf.layers.dense(inputs=dense1, units=512, activation=tf.nn.relu,
                         kernel_initializer=tf.truncated_normal_initializer(stddev=0.01))


keep_prob = tf.placeholder(tf.float32) # keep_prob: 1.0 means 100% keep
h_fcl_drop = tf.nn.dropout(dense2,keep_prob) # dropout
logits = tf.layers.dense(inputs=h_fcl_drop, units=1, activation=None,
                         kernel_initializer=tf.truncated_normal_initializer(stddev=0.01))
#--------------------------------------end build networks


config = tf.ConfigProto()
config.gpu_options.allow_growth = True
saver = tf.train.Saver()

sess = tf.Session(config=config) 
sess.run(tf.global_variables_initializer())
saver.restore(sess, tf.train.latest_checkpoint('checkpoint2/'))



# Images


def image_classifier(image):
    image_processed, processed_flag = face_preprocessing(image)
    if processed_flag == 0:
        results = {}
        results['no face detected']= 0
        return 'no face detected'
    
    #image = np.array(image)
    image = cv2.resize(image_processed, (w, h),interpolation=cv2.INTER_AREA)
    print(image.shape)
    colorimage_b = cv2.equalizeHist(image[:,:,0])
    colorimage_g = cv2.equalizeHist(image[:,:,1])
    colorimage_r = cv2.equalizeHist(image[:,:,2])
    
    # Next we stack our equalized channels back into a single image
    image_feed = np.stack((colorimage_b,colorimage_g,colorimage_r), axis=2)
    image_feed = np.reshape(image_feed, (1, w, h, 3))
    image_feed = image_feed.astype(np.float32)

    logits_out = sess.run([logits ], feed_dict={x: image_feed, keep_prob:1.0})
    #normalized_score = (logits_out[0]+4326668288.0)/(8428149760.0+4326668288.0)
    normalized_score = (logits_out[0]+40.463287353515625)/(31.093469619750977+40.463287353515625)
    if normalized_score > 1:
        normalized_score == 1
    if normalized_score < 0:
        normalized_score == 0
 
    #results[''] = (logits_out[0]+4326668288.0)/(8428149760.0+4326668288.0)
    #results['risk']= normalized_score
    return 'The predicted risk is:', normalized_score[0]

title = "Demonstration of skin cancer risk prediction"
description = """
This app is a proof-of-concept demonstration of predicting the risk of developing skin cancer\n
Please kindly note that the model was trained with facial images of participants (age > 50) from the [Rotterdam Study](http://www.epib.nl/research/ergo.htm). \n
Facial images were taken in a 3D imaging room with consistent ambient lighting \n
For more information, please check: https://www.medrxiv.org/content/10.1101/2023.10.04.23296549v1\n

To start, please upload a frontal facial image:

"""
examples=[
['01.jpg', 'Simple Lines'], ['02.jpg', 'Simple Lines'], ['03.jpg', 'Simple Lines']
]

with gr.Blocks() as demo:
    uploaded_image = gr.Image(type="numpy")
    txt_output = gr.Textbox(value="", label="Output")
    btn = gr.Button(value="Submit")
    btn.click(image_classifier, inputs=[uploaded_image], outputs=[txt_output])

#demo = gr.Interface(fn=image_classifier, inputs=uploaded_image, outputs="label", title=title, description=description)
#demo.launch(show_api=False)
demo.launch()

sess.close()