import gradio as gr
import os

# -*- coding: utf-8 -*-

import cv2
import numpy as np
import torch
from torchvision import transforms
from simple_vae import VAE
from PIL import Image
import tensorflow.compat.v1 as tf
tf.disable_v2_behavior()


import imutils
import dlib
from facealigner import FaceAligner
from imutils.face_utils import rect_to_bb
from imutils import face_utils



torch.hub.download_url_to_file(os.environ['MODEL'], 'ae_trained_model.pth')


#-------------------------------start facial preprocessing------------------------------
detector_size = 512

# construct the arguments; shape-predictor & image
shape_predictor = 'shape_predictor_68_face_landmarks.dat'

#initialize dlib's face detector (HOG-based) and then create
# the facial landmark predictor and the face aligner
detector = dlib.get_frontal_face_detector()
predictor = dlib.shape_predictor(shape_predictor)
fa = FaceAligner(predictor, desiredFaceWidth=detector_size) 


def face_preprocessing(image_src):#,save_name):

    image_resized = imutils.resize(image_src, width=768)   
    gray = cv2.cvtColor(image_resized, cv2.COLOR_BGR2GRAY)
    rects = detector(gray, 2)
    if len(rects) == 0:
        print('no face detected')
        return image_src, 0
    rect = rects[0]
    #print(image_resized.shape, gray.shape, rect)
    img = fa.align(image_resized, gray, rect)
    #print(img.shape)
    #exit(0)
    gray2 = img.copy() 
    rects2 = detector(gray2, 2)  #########
    if len(rects2) == 0:
        print('no face detected after alignment')
        return img, 0
    rect = rects2[0]

    lm = predictor(gray2, rect)  
    lm = face_utils.shape_to_np(lm)

    left = lm[0]
    right = lm[16]
    top = lm[20]
    nosetip = lm[30]
    jaw = lm[8]
    n=60
    #print(left)
    #print(2*(left[0]-n)-(1024-jaw[1]),jaw[1],left[0]-n,1024-(left[0]-n))
    if left[0]-n >= detector_size-(left[0]-n) or left[0]-n > detector_size-(left[0]-n):
        print('not able to crop')
        return img, 0
    img_crop = img[left[0]-n:detector_size-(left[0]-n),left[0]-n:detector_size-(left[0]-n)]
    #mg_crop = img[ 2*(left[0]-n)-(1024-jaw[1]):jaw[1],left[0]-n:1024-(left[0]-n)]


    gray3 = img_crop.copy() 
    rects3= detector(gray3, 2)  #########
    if len(rects3) == 0:
        print('no face detected after cropping')
        return img, 0
    rect = rects3[0]

    lm = predictor(gray3, rect)  
    lm = face_utils.shape_to_np(lm)



    n_size=img_crop.shape[0]
    landmarks_points=[]
    for n in range(0,17):
        if n == 0:
            x = 0
            y = 0
        elif n == 16:
            x=n_size
            y=0
        else:
            x=lm[n][0]
            y=lm[n][1]

        landmarks_points.append((x,y))
    #print(landmarks_points)
    #exit(0)
    target_gray=cv2.cvtColor(img_crop,cv2.COLOR_RGB2GRAY)
    mask=np.zeros_like(target_gray)
    points=np.array(landmarks_points,np.int32)
    
    convexhull=cv2.convexHull(points)
    
    cv2.fillConvexPoly(mask,convexhull,255)

    target_face_1=cv2.bitwise_and(img_crop,img_crop,mask=mask)


    return target_face_1, 1


#----------------------------end facial preprocessing------------


device = torch.device('cpu')

model_ae = VAE(device=device, is_train=False).to(device)

try:
    model_ae.load_state_dict(torch.load('ae_trained_model.pth',map_location='cpu'))
except Exception as e:
    print(f"Error loading model: {str(e)}")

# Images  



batch_size = 1
x = tf.placeholder(tf.float32, shape=[batch_size, 200], name='x')
logits = tf.layers.dense(inputs=x, units=1, activation=None, name='dense',
                         kernel_initializer=tf.truncated_normal_initializer(stddev=0.01))
config = tf.ConfigProto()
config.gpu_options.allow_growth = True
saver = tf.train.Saver()

sess = tf.Session(config=config) 
sess.run(tf.global_variables_initializer())
saver.restore(sess, tf.train.latest_checkpoint('checkpoint_dcph/'))


def image_classifier(image):
    image_switch_ch = image.copy()
    image_switch_ch[:,:,0] = image[:,:,2]
    image_switch_ch[:,:,1] = image[:,:,1]
    image_switch_ch[:,:,2] = image[:,:,0]
    image_processed, processed_flag = face_preprocessing(image_switch_ch)
    if processed_flag == 0:
        print('no face detected')
        return 'no face detected'
    image_processed_resized = cv2.resize(image_processed, (128, 128),interpolation=cv2.INTER_AREA)
    colorimage_b = cv2.equalizeHist(image_processed_resized[:,:,0])
    colorimage_g = cv2.equalizeHist(image_processed_resized[:,:,1])
    colorimage_r = cv2.equalizeHist(image_processed_resized[:,:,2])
    # Next we stack our equalized channels back into a single image
    image_processed_resized_eq = np.stack((colorimage_b,colorimage_g,colorimage_r), axis=2).astype(dtype='float32')
    image_processed_resized_eq = image_processed_resized_eq/255.0
    img_tensor = torch.tensor(image_processed_resized_eq).to(torch.float32)
    img_tensor = img_tensor.permute(2, 0, 1).unsqueeze(0)
    #print(img_tensor.shape,img_tensor)
    save_z = []
    with torch.no_grad():
        model_ae.eval()
        latent_z = model_ae.encode(img_tensor)
        save_z = latent_z.detach().cpu().numpy()
        #print(save_z)

    logits_out = sess.run(logits, feed_dict={x: save_z})
    normalized_score = (logits_out[0]+10.22614574432373)/(5.887106418609619+10.22614574432373)
    normalized_score =float(normalized_score)
    if normalized_score > 1:
        normalized_score = 1
    if normalized_score < 0:
        normalized_score = 0

    return f'The predicted risk is: {normalized_score:.2f}'

title = "Demonstration of skin cancer risk prediction"
description = """

"""
examples_xai=[
 ['02.jpg'], ['03.jpg'],['04.jpg'], ['05.jpg'], ['06.jpg'],['07.jpg'], ['08.jpg'], ['09.jpg'],['10.jpg'], ['11.jpg']
]

examples_external=[
 ['baby.jpg'],['elderly.jpg']
]


with gr.Blocks() as demo:
    gr.Markdown(
    """
    # Predict the risk of developing skin cancer from facial image
    This app is a proof-of-concept demonstration of predicting the risk of developing skin cancer from 2D facial image. Link to the [manuscript](https://www.medrxiv.org/content/10.1101/2023.10.04.23296549v1).
    
    <strong>Abstract</strong><br>
    Background: Efficient identification of individuals at high risk of skin cancer is crucial for implementing personalized screening strategies and subsequent care. While Artificial Intelligence holds promising potential for predictive analysis using image data, its application for skin cancer risk prediction utilizing facial images remains unexplored. We present a neural network-based explainable artificial intelligence (XAI) approach for skin cancer risk prediction based on 2D facial images and compare its efficacy to 18 established skin cancer risk factors using data from the Rotterdam Study.
    
    Methods: The study employed data from the Rotterdam population-based study in which both skin cancer risk factors and 2D facial images and the occurrence of skin cancer were collected from 2010 to 2018. We conducted a deep-learning survival analysis based on 2D facial images using our developed XAI approach. We subsequently compared these results with survival analysis based on skin cancer risk factors using cox proportional hazard regression.
    
    Findings: Among the 2,810 participants (mean Age=68.5±9.3 years, average Follow-up=5.0 years), 228 participants were diagnosed with skin cancer after photo acquisition. Our XAI approach achieved superior predictive accuracy based on 2D facial images (c-index=0.72, SD=0.05), outperforming that of the known risk factors (c-index=0.59, SD=0.03).
    
    Interpretation: This proof-of-concept study underscores the high potential of harnessing facial images and a tailored XAI approach as an easily accessible alternative over known risk factors for identifying individuals at high risk of skin cancer.
    
    <strong>Please kindly note that:</strong><br>
    <strong>1) This app does not collect any uploaded image data;</strong><br>
    2) The model was trained with facial images of participants (age > 50, Dutch European) from the [Rotterdam Study](http://www.epib.nl/research/ergo.htm), and images were taken in a room with consistent ambient lighting.
    """)
    uploaded_image = gr.Image(type="numpy")
    txt_output = gr.Textbox(value="", label="Output")
    btn = gr.Button(value="Submit")
    btn.click(image_classifier, inputs=[uploaded_image], outputs=[txt_output])
    gr.Markdown("## Image examples generated by our XAI approach")
    gr.Examples(
        examples=examples_xai,
        inputs=uploaded_image,
        outputs=[txt_output],
        fn=image_classifier,
        cache_examples=True,
    )
    gr.Markdown("## External image examples")
    gr.Examples(
        examples=examples_external,
        inputs=uploaded_image,
        outputs=[txt_output],
        fn=image_classifier,
        cache_examples=True,
    )
#demo = gr.Interface(fn=image_classifier, inputs=uploaded_image, outputs="label", title=title, description=description)
#demo.launch(show_api=False)
demo.launch()

sess.close()