import os
from dotenv import load_dotenv
import msal
import requests
# import json


def send_email(subject, email, name, organization, meddra_license, agree_terms, save_data) -> None:
    """
    Send an email with user settings
    @param save_data:
    @type save_data:
    @param agree_terms:
    @type agree_terms:
    @param meddra_license:
    @type meddra_license:
    @param organization:
    @type organization:
    @param name:
    @type name:
    @param email:
    @type email:
    @param subject:
    @type subject:
    @return:
    @rtype:
    """

    body = f"""
        Request for API Key - Safeterm

        Settings:
        - Free Demo (30 days, 50 terms limit)
        - Version: 26.0
        - Language: English

        Contact Information:
        - Email: {email}
        - Full Name: {name}
        - Organization: {organization}

        Terms of use:
        - Valid medDRA License: {meddra_license}
        - Agrees to Safeterm terms: {agree_terms}
        - Consent to data storage: {save_data}
        """

    load_dotenv()

    client_id = os.getenv("CLIENT_ID")
    client_secret = os.getenv("CLIENT_SECRET")
    tenant_id = os.getenv("TENANT_ID")
    authority = f"https://login.microsoftonline.com/{tenant_id}"
    sender = os.getenv("MAIL_SENDER")
    receiver = os.getenv("MAIL_RECIPIENT")
    cc_receiver = os.getenv("CC_RECIPIENT")

    app = msal.ConfidentialClientApplication(
        client_id=client_id,
        client_credential=client_secret,
        authority=authority)

    scopes = ["https://graph.microsoft.com/.default"]

    result = app.acquire_token_silent(scopes, account=None)

    if not result:
        print("No suitable token exists in cache. Let's get a new one from Azure Active Directory.")
        result = app.acquire_token_for_client(scopes=scopes)

    if "access_token" in result:
        endpoint = f'https://graph.microsoft.com/v1.0/users/{sender}/sendMail'
        email_msg = {
            'Message': {
                'Subject': subject,
                'Body': {
                    'ContentType': 'Text',
                    'Content': body
                },
                'ToRecipients': [{'EmailAddress': {'Address': receiver}}],
                'CcRecipients': [{'EmailAddress': {'Address': cc_receiver}}]  # Added CcRecipients here
            },
            'SaveToSentItems': 'true'
        }

        r = requests.post(endpoint, headers={'Authorization': 'Bearer ' + result['access_token']}, json=email_msg)

        if r.ok:
            print('Sent email successfully')
        else:
            print(r.json())
    else:
        print(result.get("error"))
        print(result.get("error_description"))
        print(result.get("correlation_id"))

# Sample usage
# send_email("Test Email Hugging Face Demo", "This is a test email.")
