import gradio as gr
import requests
import io
from PIL import Image
import os


API_URL = "https://api-inference.huggingface.co/models/stabilityai/stable-diffusion-xl-base-1.0"

def query(payload):
    auth_hf_api_token = os.environ.get("AUTH_HF_API_TOKEN")
    authorization = "Bearer " + auth_hf_api_token
    headers = {"Authorization": authorization}
    response = requests.post(API_URL, headers=headers, json=payload)
    return response.content

def genImage(character_name, description_of_the_character):
    input = "Create a movie poster for " + character_name + "," + description_of_the_character + ",Disney Pixar movie style"
    image_bytes = query({
        "inputs": input,
    })
    image = Image.open(io.BytesIO(image_bytes))
    return image

demo = gr.Interface(genImage, inputs=["text", "text"], outputs=["image"])
demo.launch()