from fastai.vision.all import *
import gradio as gr

def is_cat(x): return x[0].isupper()
learn_gr = load_learner('model.pkl')

categories = ('mackerel', 'red snapper', 'tilapia')

def classify_image(img):
  pred,idx,probs = learn_gr.predict(img)
  return dict(zip(categories,map(float,probs)))

image = gr.inputs.Image(shape=(192,192))
label = gr.outputs.Label()
examples = ['mackerel.jpg', 'red_snapper.jpg', 'tilapia.jpg']

intf = gr.Interface(fn=classify_image, inputs=image, outputs=label, examples=examples)
intf.launch(inline=False)
