import pandas as pd
import pandas as pd
import panel as pn
import hvplot.pandas
from itertools import cycle
from bokeh.palettes import Reds9
import folium
raw_df = pd.read_csv('zomato_data.csv')
zomato_df = raw_df.copy()
rating_type_df = zomato_df['RATING_TYPE'].value_counts().reset_index()
rating_type_df.rename(columns={'index':'RATING TYPE', 'RATING_TYPE':'COUNT OF RESTAURANTS'}, inplace=True)
foodtruck_df = zomato_df[zomato_df['CUSINE TYPE'] == 'Food Truck']
foodtruck_df.sort_values(by='RATING',ascending=False)


# Read the CSV file into a DataFrame
zomato_df = pd.read_csv('zomato_data.csv')

# Count the occurrences of each cuisine type
cuisine_counts = zomato_df['CUSINE TYPE'].value_counts()

# Create the bar plot using hvplot
bar_plot_cuisine = cuisine_counts.hvplot.bar(
    color='#E10F14',
    title='No. of Restaurants by Cuisine Type',
    xlabel='Cuisine Type',
    ylabel='Count',
    width=900,
    height=500
).opts(xrotation=90)

# Wrap the bar plot in a Panel object
panel_cuisine = pn.panel(bar_plot_cuisine)

# Create a DataFrame with the given data
rating_type_df = pd.DataFrame({
    'RATING TYPE': ['Average', 'Good', 'Very Good', 'Excellent', 'Poor', 'Very Poor'],
    'COUNT OF RESTAURANTS': [4983, 4263, 1145, 96, 56, 4]
})

# Define the hvplot chart
bar_plot_rating = rating_type_df.hvplot.bar(
    x='RATING TYPE',
    y='COUNT OF RESTAURANTS',
    color='#E10F14',
    title='Count of Restaurants by Rating Type',
    xlabel='Rating Type',
    ylabel='Count',
    width=900,
    height=500
)

# Wrap the bar plot in a Panel object
panel_rating = pn.panel(bar_plot_rating)

# Filter food trucks in Mumbai
foodtruck_df = zomato_df[zomato_df['CUSINE TYPE'] == 'Food Truck']

# Sort by rating in descending order and select the top result
best_food_truck = foodtruck_df.sort_values(by='RATING', ascending=False).head()

# Create the bar plot using hvplot
bar_plot_best_food_truck = best_food_truck.hvplot.bar(
    x='NAME',
    y='PRICE',
    color='#E10F14',
    title='Best Food Truck in Mumbai: Price vs. Name',
    xlabel='Food Truck Name',
    ylabel='Price',
    hover_cols=['RATING', 'REGION', 'CUSINE_CATEGORY'],
    rot=90,
    width=900,
    height=500
)

# Wrap the bar plot in a Panel object
panel_best_food_truck = pn.panel(bar_plot_best_food_truck)

# Filter seafood restaurants in Mumbai
seafood_df = zomato_df[zomato_df['CUSINE_CATEGORY'].notna() & zomato_df['CUSINE_CATEGORY'].str.contains('Seafood')]

# Get top 10 seafood restaurants in Mumbai, sorted by rating
top_seafood_df = seafood_df.sort_values(by='RATING', ascending=False).head(10)

# Create the bar plot using hvplot
bar_plot_top_seafood = top_seafood_df.hvplot.bar(
    x='NAME',
    y='PRICE',
    color='#E10F14',
    title='Top 10 Seafood Restaurants in Mumbai: Price vs. Name',
    xlabel='Restaurant Name',
    ylabel='Price',
    hover_cols=['RATING', 'REGION', 'CUSINE_CATEGORY'],
    rot=90,
    width=900,
    height=500
)

# Wrap the bar plot in a Panel object
panel_top_seafood = pn.panel(bar_plot_top_seafood)

# Define Panel widgets
yaxis_radio = pn.widgets.RadioButtonGroup(
    name='Y axis',
    options=['Cuisine Type', 'Rating Type', 'Best Food Truck', 'Top 10 Seafood', 'Highest Rated', 'Top Avg Price', 'Chinese Resto', 'Price vs Rating', 'Region vs Price', 'Map'],
    button_type='danger',
    inline=True,
    value='Cuisine Type'
)

# Define the Panel layout
panel_layout = pn.Column(
    pn.Row(yaxis_radio)
)

# Create the map centered at Mumbai with dark mode
mumbai_map = folium.Map(location=[19.0760, 72.8777], zoom_start=12, tiles="StamenTonerBackground")

# Add a marker for Mumbai
folium.Marker(
    location=[19.0760, 72.8777],
    popup='<b>Mumbai</b>',
    icon=folium.Icon(color='red', icon_color='white', icon='heart', prefix='fa')
).add_to(mumbai_map)

# Add markers for the specified locations
locations = [
    {'name': 'Hitchki', 'region': 'Bandra', 'rating': '4.8', 'latitude': 19.0590, 'longitude': 72.8292, 'cuisine': 'Indian'},
    {'name': 'Downtown China', 'region': 'Andheri', 'rating': '4.9', 'latitude': 19.1136, 'longitude': 72.8697, 'cuisine': 'Chinese'},
    {'name': 'The Northern Vibe', 'region': 'Powai', 'rating': '4.7', 'latitude': 19.1187, 'longitude': 72.9073, 'cuisine': 'Continental'},
    {'name': 'Rajdhani', 'region': 'Ghatkopar', 'rating': '4.8', 'latitude': 19.0866, 'longitude': 72.9081, 'cuisine': 'Indian'},
    {'name': 'Trumpet Sky Lounge', 'region': 'Andheri', 'rating': '4.9', 'latitude': 19.1189, 'longitude': 72.8537, 'cuisine': 'International'},
    {'name': 'Dessertino', 'region': 'Kandivali', 'rating': '4.7', 'latitude': 19.2128, 'longitude': 72.8376, 'cuisine': 'Desserts'}
]

for location in locations:
    popup_content = f"<b>Name:</b> {location['name']}<br><b>Region:</b> {location['region']}<br><b>Rating:</b> {location['rating']}<br><b>Cuisine:</b> {location['cuisine']}"
    if location['name'] == 'Dessertino':
        icon = folium.Icon(color='red', icon_color='white', icon='coffee', prefix='fa')
    else:
        icon = folium.Icon(color='red', icon_color='white', icon='cutlery', prefix='fa')
    folium.Marker(
        location=[location['latitude'], location['longitude']],
        popup=popup_content,
        icon=icon
    ).add_to(mumbai_map)
    
title_html = """
<div style="font-size: 17px; font-weight: bold; text-align: left;">The best Restaurant to order food with best price and Quality</div>
"""
# Wrap the map in a Panel object
panel_map = pn.pane.HTML(title_html + mumbai_map._repr_html_(), width=800, height=600)

# Define the callback function for the radio button
def update_chart(event):
    if event.new == 'Cuisine Type':
        panel_layout[1:] = [panel_cuisine]
    elif event.new == 'Rating Type':
        panel_layout[1:]= [panel_rating]
    elif event.new == 'Best Food Truck':
        panel_layout[1:] = [panel_best_food_truck]
    elif event.new == 'Top 10 Seafood':
        panel_layout[1:] = [panel_top_seafood]
    elif event.new == 'Highest Rated':
        # Filter the DataFrame for highest rated restaurants
        highest_rated = zomato_df[zomato_df['RATING'] >= 4.7]

        # Create the bar plot using hvplot
        bar_plot_highest_rated = highest_rated.hvplot.bar(
            x='NAME',
            y='PRICE',
            color='#E10F14',
            title='Highest Rated Restaurants in Mumbai: Price vs. Name',
            xlabel='Restaurant Name',
            ylabel='Price',
            hover_cols=['RATING', 'REGION', 'CUSINE_CATEGORY'],
            rot=90,
            width=900,
            height=500
        )

        # Wrap the bar plot in a Panel object
        panel_highest_rated = pn.panel(bar_plot_highest_rated)
        panel_layout[1:] = [panel_highest_rated]
    elif event.new == 'Top Avg Price':
        # Filter the DataFrame for ratings greater than or equal to 4.5
        filtered_df = zomato_df[zomato_df['RATING'] >= 4.5]

        # Calculate the mean price for each combination of 'REGION' and 'CUSINE TYPE'
        highest_rated_price_df = filtered_df.groupby(['REGION', 'CUSINE TYPE'])['PRICE'].mean().reset_index()

        # Sort the DataFrame by 'REGION' in alphabetical order
        highest_rated_price_df = highest_rated_price_df.sort_values('REGION')

        # Create a scatter plot with rotated labels and star marker
        scatter_plot_top_avg_price = highest_rated_price_df.hvplot.scatter(
            x='REGION',
            y='PRICE',
            c='CUSINE TYPE',
            cmap='Category10',
            title='Avg Price Distribution of High-rated restaurants for each Cuisine Type',
            size=100,  # Increase the marker size
            rot=90,
            width=900,
            height=500,
            marker='*',
        )

        # Create a Panel object with the scatter plot
        panel_top_avg_price = pn.panel(scatter_plot_top_avg_price)
        panel_layout[1:] = [panel_top_avg_price]
    elif event.new == 'Chinese Resto':
        zomato_df_cleaned = zomato_df.dropna(subset=['CUSINE_CATEGORY'])
        chinese_df = zomato_df_cleaned[zomato_df_cleaned['CUSINE_CATEGORY'].str.contains('Chinese')]
        chinese_rest_df = chinese_df.groupby(by='REGION').agg({'NAME': 'count', 'PRICE': 'mean'}).rename(columns={'NAME': 'COUNT OF RESTAURANTS'}).reset_index()
        chinese_rest_df = chinese_rest_df.sort_values('COUNT OF RESTAURANTS', ascending=False).head(25)
        bar_plot = chinese_rest_df.hvplot.bar(
            x='REGION',
            y='COUNT OF RESTAURANTS',
            color='#E10F14',  # Set the color to red
            title='No. of Chinese Restaurants by Places',
            xlabel='Region',
            ylabel='Count of Restaurants',
            rot=90,
            height=500,
            width=900
        )
        layout = pn.Column(bar_plot)
        panel_layout[1:] = [bar_plot]
    elif event.new == 'Price vs Rating':
        # Calculate the mean price and rating for each cuisine type
        price_rating_df = zomato_df.groupby(['CUSINE TYPE', 'RATING'])['PRICE'].mean().reset_index()
        hvplot_price_rating = price_rating_df.hvplot.line(
            x='RATING',
            y='PRICE',
            by='CUSINE TYPE',
            title='Price vs Rating by Cuisine Type',
            xlabel='Rating',
            ylabel='Price',
            width=900,
            height=500,
            legend='bottom'  # Set the position of the legend to 'bottom'
        )

        # Set the number of legend columns
        hvplot_price_rating.opts(legend_cols=6)  # Adjust the value to your desired maximum number of legend items per row

        # Wrap the Hvplot plot in a Panel object
        panel_price_vs_rating = pn.panel(hvplot_price_rating)
        panel_layout[1:] = [panel_price_vs_rating]
    elif event.new == 'Region vs Price':
        region_price_df = zomato_df.groupby(['REGION'])['PRICE'].mean().reset_index()
        scatter_plot = region_price_df.hvplot.scatter(
            x='REGION',
            y='PRICE',
            cmap='Category10',
            title='Relation between Region and Price',
            size=100,  # Increase the marker size
            rot=90,
            width=900,
            height=600,
            marker='*',
            color='red'
        )
        panel_region_vs_price = pn.Column(scatter_plot)
        panel_layout[1:] = [panel_region_vs_price]
    elif event.new == 'Map':
        panel_layout[1:] = [panel_map]

yaxis_radio.param.watch(update_chart, 'value')

# Display the initial chart
panel_layout.append(panel_cuisine)

# Display the Panel layout
panel_layout
dashboard = panel_layout
import panel as pn
pn.extension()  # Add this line to load the Panel extension

# Layout using Template
template = pn.template.FastListTemplate(
    title='Zomato Mumbai Dashboard', 
    sidebar=[
        pn.pane.PNG('zomato.png', sizing_mode='scale_both'),
        pn.pane.Markdown("# Performing Exploratory Data Analysis"),  
        pn.pane.Markdown("1. How many restaurants are in Mumbai for each type of cuisine?"),
        pn.pane.Markdown("2. What are the percentage of restaurants by Rating Type in Mumbai?"),
        pn.pane.Markdown("3. Which are the Top 10 highest rated Seafood Restaurant in Mumbai?"),
        pn.pane.Markdown("4. Which is the best Food Truck in Mumbai?"),
        pn.pane.Markdown("5. Which places have the highest rated restaurant for each Cuisine Type in Mumbai?"),
        pn.pane.Markdown("6. What is the Avg Price Distibution of highest rated restaurant for each Cuisine Type in Mumbai?"),
        pn.pane.Markdown("7. Which areas have a large number of Chinese Restaurant Market?"),
        pn.pane.Markdown("8. Is there a relation between Price and Rating by each Cuisine Type?"),
        pn.pane.Markdown("9. Is there a relation between Region and Price?"),
        pn.pane.Markdown("10. Can we map the best restraunt with high quality food?"),
    ],
    main = [pn.Row(pn.Column(dashboard)),
            pn.Row(pn.pane.Markdown("Designed and Developed with ❤️ by Chitranshu Nagdawane © 2023"))
           ],
    accent_base_color="#E10F14",
    header_background="#E10F14"
)

template.servable()
