import pandas as pd
import numpy as np
import panel as pn
pn.extension('tabulator')

import hvplot.pandas

project_data = pd.read_csv(r'DMart.csv')
project_data.columns
project_data.info()
project_data.describe()
project_data.isna().sum()
project_data.shape
project_data['Brand'] = project_data['Brand'].fillna('others')
project_data.isna().sum()
project_data = project_data.dropna()
project_data.isna().sum()
df = pd.DataFrame(project_data)
idf = df.interactive()
df.groupby(by=["SubCategory","Quantity"], dropna=False, sort=True).sum()
import pandas as pd
import panel as pn
import hvplot.pandas
import seaborn as sns
import pandas as pd
import seaborn as sns
import hvplot.pandas
import panel as pn

# Assuming your dataset is stored in a DataFrame called 'df'

# Create an interactive DataFrame
idf = df.interactive()

# Define Panel widgets for Top 10 Brands and Top 10 Categories
brand_count = df['Brand'].value_counts().nlargest(10)
category_count = df['Category'].value_counts().nlargest(10)

# Define the hvplot charts with increased size
brand_chart = brand_count.hvplot.bar(rot=90, title='Top 10 Brands', color=['#206b33'], width=800, height=400)  # Different shades of green
category_chart = category_count.hvplot.bar(rot=90, title='Top 10 Categories', color=['#206b33'], width=800, height=400)

# Create brand_price and category_price dictionaries
brand_price = {}
category_price = {}

def brand_and_top_price():
    for index, row in project_data.iterrows():
        if row["Brand"] in brand_price:
            if brand_price.get(row["Brand"]) < row["Price"]:
                brand_price[row["Brand"]] = row["Price"]
        else:
            brand_price[row["Brand"]] = row["Price"]
            
def category_and_top_price():
    for index, row in project_data.iterrows():
        if row["Category"] in category_price:
            if category_price.get(row["Category"]) < row["Price"]:
                category_price[row["Category"]] = row["Price"]
        else:
            category_price[row["Category"]] = row["Price"]
            
brand_and_top_price()
category_and_top_price()
project_data_interactive = project_data.interactive()
idf = df.interactive()

# Define Panel widgets
category_1 = project_data['Category'].value_counts().nlargest(10)
brand_1 = project_data["Brand"].value_counts().nlargest(15).sort_values(ascending=False)
# Define the hvplot charts
category_chart1 = category_1.hvplot.bar(rot=90, title='Category Distribution', color=['#206b33'], width=800, height=400)
brand_chart1 = brand_1.hvplot.bar(rot=90, title='Brand Count Distribution (Top 15)', color=['#206b33'], width=800, height=400)
price_chart = df.hvplot(y='Price', color='#006400', width=800, height=400)
discounted_price_chart = df.hvplot(y='DiscountedPrice', color='#006400', width=800, height=400)
brand_price = dict(sorted(brand_price.items(), key=lambda item: item[1], reverse=True))
category_price = dict(sorted(category_price.items(), key=lambda item: item[1], reverse=True))

df_brand = pd.DataFrame(brand_price.items(), columns=['Brand', 'Price']).head(20)
df_category = pd.DataFrame(category_price.items(), columns=['Category', 'Price']).head(20)

# Create a reversed green color palette
green_palette = sns.color_palette('Greens', n_colors=20)
reversed_palette = list(reversed(green_palette))

# Create brand bar chart using hvPlot
brand_price_chart = df_brand.hvplot.bar(x='Brand', y='Price', rot=90, color=reversed_palette,
                                    title='Top Price in Every Brand', xlabel='Brand', ylabel='Price',
                                    width=800, height=400)

# Create category bar chart using hvPlot
category_price_chart = df_category.hvplot.bar(x='Category', y='Price', rot=90, color=green_palette[::-1],
                                           title='Top Price in Every Category', xlabel='Category', ylabel='Price',
                                           width=800, height=400)

# Define Panel widgets
yaxis_radio = pn.widgets.RadioButtonGroup(
    name='Y axis',
    options=['Top 10 Brands', 'Top 10 Categories', 'Top Price Brands', 'Top Price Categories', 'Category Distribution', 'Brand Count Distribution', 'Price', 'DiscountedPrice'],
    button_type='success',
    inline=True
)

# Define the Panel layout
panel_layout = pn.Column(
    yaxis_radio
)

# Define the callback function for the radio button
def update_chart(event):
    if event.new == 'Top 10 Brands':
        panel_layout[1:] = [brand_chart]
    elif event.new == 'Top 10 Categories':
        panel_layout[1:] = [category_chart]
    elif event.new == 'Top Price Brands':        
        panel_layout[1:] = [brand_price_chart]
    elif event.new == 'Top Price Categories':
        panel_layout[1:] = [category_price_chart]
    elif event.new == 'Category Distribution':
        panel_layout[1:] = [category_chart1]
    elif event.new == 'Brand Count Distribution':
        panel_layout[1:] = [brand_chart1]
    elif event.new == 'Price':
        panel_layout[1:] = [price_chart]
    elif event.new == 'DiscountedPrice':
        panel_layout[1:] = [discounted_price_chart]

yaxis_radio.param.watch(update_chart, 'value')

# Display the initial chart
panel_layout.append(brand_chart)

# Display the Panel layout
panel_layout
dashboard = panel_layout
import panel as pn
pn.extension()  # Add this line to load the Panel extension

# Layout using Template
template = pn.template.FastListTemplate(
    title='D-mart Products Analysis Dashboard', 
    sidebar=[
        pn.pane.PNG('Dmart.png', sizing_mode='scale_both'),
        pn.pane.Markdown("# Key Performance Indicators (KPIs) of the EDA"),  
        pn.pane.Markdown("1. Count of Brands: The count of each brand, indicating brand popularity or representation in the dataset."),
        pn.pane.Markdown("2. Count of Prices: The count of different price values, providing insights into price distribution."),
        pn.pane.Markdown("3. Count of Categories: The count of each category, helping understand the distribution of products across categories."),
        pn.pane.Markdown("4. Price Distribution: The density plot shows the distribution of prices, allowing analysis of price ranges and outliers."),
        pn.pane.Markdown("5. Top Price in Every Brand: Identifies the brands with the highest prices, indicating premium or luxury brands."),
        pn.pane.Markdown("6. Top Price in Every Category: Shows the categories with the highest prices, providing insights into expensive product categories."),
        pn.pane.Markdown("7. Grouping and Summarizing: Summarizes the data by grouping based on 'SubCategory' and 'Quantity,' enabling analysis of aggregated metrics."),
        pn.pane.Markdown("8. Price Distribution (Discounted vs. Original): Compares the distributions of discounted and original prices, offering insights into pricing strategies and discounts.")
    ],
    main = [pn.Row(pn.Column(dashboard)),
            pn.Row(pn.pane.Markdown("DMart is a one-stop supermarket chain that aims to offer customers a wide range of basic home and personal products under one roof. Each DMart store stocks home utility products - including food, toiletries, beauty products, garments, kitchenware, bed and bath linen, home appliances and more - available at competitive prices that our customers appreciate. Our core objective is to offer customers good products at great value.DMart was started by Mr. Radhakishan Damani and his family to address the growing needs of the Indian family. From the launch of its first store in Powai in 2002, DMart today has a well-established presence in 327 locations across India. With D-marts mission is to be the lowest priced retailer in the regions we operate, our business continues to grow with new locations planned in more cities.The supermarket chain of DMart stores is owned and operated by Avenue Supermarts Ltd. (ASL). The company has its headquarters in Mumbai.The brands D Mart, D Mart Minimax, D Mart Premia, D Homes, Dutch Harbour, etc are brands owned by ASL.")),
            pn.Row(pn.pane.Markdown("Designed and Developed with ❤️ by Chitranshu Nagdawane © 2023"))
           ],
    accent_base_color="#206b33",
    header_background="#206b33"
)

template.servable()




