import streamlit as st
from streamlit_image_comparison import image_comparison

st.set_page_config(page_title="Prakalpa", page_icon="🔭", layout="centered")
# title_container = st.container()
# col1, col2 = st.columns([1, 20])
# image = Image.open('C:/Users/Chirag Chauhan/Desktop/100409820-removebg-preview.png')
# with title_container:
#     with col1:
#         st.sidebar.image(image, width=300)
    # with col2:
    #     st.sidebar.markdown('<h1 style="color: blue;">Prakalpa</h1>',
    #     unsafe_allow_html=True)
st.sidebar.markdown("# *Hubble vs James Webb*")


def main():
    html_temp = """
    <style>
    #MainMenu {visibility:hidden;}
    tbody th {display:none}
    .blank {display:none}
    h1 {
    text-align: center;
    }
    [data-testid="stSidebar"][aria-expanded="true"] > div:first-child {
        width: 450px;
    }
    [data-testid="stSidebar"][aria-expanded="false"] > div:first-child {
        width: 450px;
    }
    div.block-container{top:-20px;}
    </style>
    """

    st.markdown(html_temp, unsafe_allow_html=True)

    selection = st.sidebar.multiselect('Select comparison image:', ['Southern Nebula', "Stephan's Quintet",
                                                                    'Galaxy Cluster SMACS 0723'])

    if 'Southern Nebula' in selection:
        with st.expander('Southern Nebula'):
            image_comparison(
                img1="https://www.webbcompare.com/img/hubble/southern_nebula_700.jpg",
                img2="https://www.webbcompare.com/img/webb/southern_nebula_700.jpg",
                label1="Hubble",
                label2="Webb",
                width=660,
                make_responsive=True
            )

    if "Stephan's Quintet" in selection:
        with st.expander("Stephan's Quintet"):
            image_comparison(
                img1="https://www.webbcompare.com/img/hubble/stephans_quintet_1400.jpg",
                img2="https://www.webbcompare.com/img/webb/stephans_quintet_1400.jpg",
                label1="Hubble",
                label2="Webb",
                width=660,
                make_responsive=True
            )

    if "Galaxy Cluster SMACS 0723" in selection:
        with st.expander('Galaxy Cluster SMACS 0723'):
            image_comparison(
                img1="https://www.webbcompare.com/img/hubble/deep_field_700.jpg",
                img2="https://www.webbcompare.com/img/webb/deep_field_700.jpg",
                label1="Hubble",
                label2="Webb",
                width=660,
                make_responsive=True
            )

    # if "Carina Nebula" in selection:
    #     with st.expander('Carina Nebula'):
    #         image_comparison(
    #             img1="https://www.webbcompare.com/img/hubble/carina_1400.png",
    #             img2="https://www.webbcompare.com/img/webb/carina_1400.jpg",
    #             label1="Hubble",
    #             label2="Webb",
    #             width=660,
    #             make_responsive=True,
    #             starting_position=50
    #         )


main()