import requests
from bs4 import BeautifulSoup as bs
import src.constants as constants_utils


class WEATHER:
    def __init__(self):
        self.base_url = 'https://nwp.imd.gov.in/blf/blf_temp'
        self.headers = {
            'Accept': 'text/html,application/xhtml+xml,application/xml;q=0.9,image/avif,image/webp,image/apng,*/*;q=0.8,application/signed-exchange;v=b3;q=0.7',
        }

        self.state_names_codes = {}
        self.districts = []


    def get_state_names_codes(
        self
    ):
        response = requests.get(
            self.base_url,
            headers=self.headers,
        )

        soup = bs(response.text, 'html.parser')
        for option in soup.find_all('option'):
            if option.text.strip() == 'Select':
                continue
            self.state_names_codes[option.text.strip()] = str(option['value'].split('=')[-1][:2])
        
        return self.state_names_codes


    def get_district_names(
        self,
        state_name
    ):
        url = f"{self.base_url}/dis.php?value={constants_utils.WEATHER_FORECAST_STATE_CODES.get(state_name, '') + state_name}"
        response = requests.get(
            url,
            headers=self.headers,
        )

        soup = bs(response.text, 'html.parser')
        self.districts = soup.findAll('select', {'name': 'dis'}, limit=None)
        self.districts = [district.strip() for district in self.districts[0].text.split('\n') if district and district != 'Select']
        return self.districts


    # Weather forecast from Govt. website
    def get_weather_forecast(
        self,
        state,
        district,
        is_block_level=False
    ):
        self.district_url = f"{self.base_url}/block.php?dis={constants_utils.WEATHER_FORECAST_STATE_CODES.get(state, '') + district}"
        self.block_url = f'{self.base_url}/table2.php'

        response = requests.get(self.district_url if not is_block_level else self.block_url)
        soup = bs(response.text, 'html.parser')
        scripts = soup.findAll('font')[0]
        return scripts.text


    # Weather using Google weather API
    def get_weather(
        self,
        city
    ):
        city = city + " weather"
        city = city.replace(" ", "+")

        headers = {
            'User-Agent': 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/58.0.3029.110 Safari/537.3'
        }
        response = requests.get(
            f'https://www.google.com/search?q={city}&oq={city}&aqs=chrome.0.35i39l2j0l4j46j69i60.6128j1j7&sourceid=chrome&ie=UTF-8', headers=headers)

        soup = bs(response.text, 'html.parser')
        location = soup.select('#wob_loc')[0].getText().strip()
        time = soup.select('#wob_dts')[0].getText().strip()
        info = soup.select('#wob_dc')[0].getText().strip()
        temperature = soup.select('#wob_tm')[0].getText().strip()
        temperature = temperature + "°C"

        return time, info, temperature
