## Clone respository using git

```bash
git clone https://huggingface.co/spaces/ChihChiu29/mychatbot
```

## Use git to push changes to huggingface repository

First use `huggingface_cli.exe login` to login (follow its instruction), then use git commands for pushing.

## Build/run via docker locally

```bash
docker build -t fastapi .
docker run  -it -p 7860:7860 fastapi
```

## CURL POST example

```bash
curl -X POST http://localhost:7860/reply -H 'Content-Type: application/json' -d '{"msg": "hi"}'
```

## Huggingface API

See: https://huggingface.co/docs/hub/api

Access info for a space: https://huggingface.co/api/spaces/ChihChiu29/mychatbot

## Directly access the server on Huggingface space

Use the embedded address, for example:

```bash
curl -X POST https://chihchiu29-mychatbot.hf.space/reply -H 'Content-Type: application/json' -d '{"msg": "hi"}'
```

## Remove dangling images

From: https://github.com/fabric8io/docker-maven-plugin/issues/501

```bash
docker rmi $(docker images -qa -f 'dangling=true')
```
