import gradio as gr
import openai
from PyPDF2 import PdfReader

def funfunc(Name, CV, Adventurous, Years):
    # Years = 5
    reader = PdfReader(CV.name)
    page = reader.pages[0]
    CV_text = page.extract_text()
    MODEL = "gpt-3.5-turbo-16k"
    response = openai.ChatCompletion.create(
        model=MODEL,
        messages=[
            {"role": "system", "content": f"You are an assistant which helps people to find their best future career "
                                          f"path based on their current CV. Your job is to answer the question: where do "
                                          f"you see this person {Years} years from now? by taking into account his\hers "
                                          f"current CV and suggest a professional trajectory for these upcoming {Years} "
                                          f"years. The current year is 2023, so your forecasting should be until 2023+{Years}."},
            {"role": "user", "content": f"My name is: {Name}"},
            {"role": "system", "content": "There is a spectrum of adventurousness according to which a career path can "
                                          "be suggested. The adventurousness parameter ranges from 0 to 5, where 0 is not "
                                          "adventurous at all (continue on the same expected track, no surprises, "
                                          "no professional development) and 5 is the most adventurous trajectory you can think of "
                                          "(explore and suggest fascinating related directions). "},
            {"role": "user", "content": f"My adventurous level is: {Adventurous}. \nMy CV is listed below: \n {CV_text}"},
            {"role": "system", "content": f"Please output the answers to the following questions: \n 1. Where do you "
                                          f"see {Name} in {Years} years? \n- Use 'they' instead of 'he' or 'she.' "
                                          f"\n- Mention their title, company, and briefly explain what they will do. "
                                          f"\n- Consider work-life balance. \n \n2. which roles will they perform during "
                                          f"these upcoming {Years} years? \n- Pick one leading option and be specific. "
                                          f"\n- Provide the precise years, title, and company for each role in a resume-like list. "
                                          f"\n- Each role should last between 6 months and 2.5 years on average."},
            {"role": "system", "content": f"Your response should follow the template: \n {Years} years from now, "
                                          f"{Name} will ... \nDuring these {Years} years, {Name} will perform the "
                                          f"following positions: \n<from year> - <to year>: <job title>, <company> \n... "
                                          f"\n Ensure that you start from the current year (2023) and go {Years} years ahead "
                                          f"(for example, 5 years from now the year will be 2028. \nMake sure that the last "
                                          f"position is aligned with the details you provided earlier."}
            # {"role": "system", "content": f"Here's an example for desired output: \nIn 3 years, Emily will be a Software Development Team Lead at ABC Tech, managing a team of developers and overseeing software development projects. They will have a healthy work-life balance, with opportunities for growth and innovation. \n \nDuring these 3 years, Emily will perform the following positions: \n2023-2024: Junior Software Developer, XYZ Company \n2024-2025: Software Developer, XYZ Company \n2025-2026: Senior Software Developer, ABC Tech \n2026-: Software Development Team Lead, ABC Tech"}
        ],
        max_tokens=500,
        temperature=1
    )

    return response['choices'][0]['message']['content']


iface = gr.Interface(
    fn=funfunc,
    inputs=["text", "file", gr.Slider(minimum=0, maximum=5, step=1), gr.Slider(minimum=1, maximum=10, step=1)],
    # inputs=["text", "file", gr.Slider(minimum=0, maximum=5, step=1)],
    outputs=["text"]
)


iface.launch()
