from transformers import RobertaTokenizerFast, EncoderDecoderModel
import torch
#initialisation de tokenizer
device = "cuda" if torch.cuda.is_available() else "cpu"
tokenizer = RobertaTokenizerFast.from_pretrained("Chemsseddine/bert2gpt2SUMM-finetuned-mlsum")
#Chemsseddine/bert2gpt2SUMM-finetuned-mlsum
#aider les token special
tokenizer.bos_token = tokenizer.cls_token
tokenizer.eos_token = tokenizer.sep_token
#initialisation du modele
model = EncoderDecoderModel.from_pretrained("Chemsseddine/bert2gpt2SUMM-finetuned-mlsum").to(device)
#tf.random.set_seed(0)
# generate summary
def generateSumm(input_texte,max,min):
  # encoder le texte entrée 
  if input_texte and input_texte.strip():
    if min<len(input_texte):

      if max>min:
        
        input_ids = tokenizer.encode(input_texte, return_tensors='pt')
    #generation de resume a l'aide de texte encodé
        summary_ids = model.generate(input_ids,#le texte encodé
            max_length=max,#la longuer maximale du sequence de sortie
            min_length=min,#la longuer minimum du sequence de sortie
            
            num_beams=5,
            repetition_penalty=2.5, 
            length_penalty=1.0, 
            early_stopping=True,#pour que la génération soit terminée lorsque toutes les hypothèses de faisceau ont atteint le jeton EOS.
            no_repeat_ngram_size=2,#aucun 2 grammes n'apparaisse deux fois#Pour éviter les répétitions du même texte,
            use_cache=True,
            do_sample = True,
           # num_return_sequences=5, 
            temperature = 0.8,
            top_k = 50,
            top_p = 0.95)
  #decodé la sequence de generé par le modele
        summary_text = tokenizer.decode(summary_ids[0], skip_special_tokens=True)
        return summary_text
      else:

        summary_text="La longueur minimale est grande que la maximale"
        return summary_text
    else:
      summary_text="La longueur de texte entré est inferieur que la minimale que vous avez choisis"
      return summary_text
      
  else :
    summary_text="Entrer votre Texte S'il vous plait"
    return summary_text


from difflib import Differ
import gradio as gr
demo = gr.Blocks()

def diff_texts(text1, text2):
    d = Differ()
    return [
        (token[2:], token[0] if token[0] != " " else None)
        for token in d.compare(text1.split(), text2.split())]


inp=gr.inputs.Textbox(label="Text Originale",placeholder="Entrer Texte ici...")
out=gr.outputs.Textbox(label="Résumé")
mx_length=gr.Slider(40, 512)
mn_length=gr.Slider(10,120)

with demo:
    gr.Markdown("***<center>Résumé Votre Text à l'aide de IA.</center>***\n\n Vous pouvez résumé votre texte par entrer le texte originale, et vous pouvez comparer le resultat avec votre texte originale en cliquant sur Comparer resultat ")
    
    with gr.Tabs():
        
        with gr.TabItem("Résumé"):
            gr.Interface(fn=generateSumm, inputs=[inp,mx_length,mn_length], outputs=out ,cache_examples=True,allow_flagging=False
                         )
        with gr.TabItem("Comparer resultat"):
            gr.Interface(diff_texts,[inp,out],gr.HighlightedText(label="Difference"),allow_flagging=False)
            
demo.launch(debug=True)