import threading
from config import *
import requests
import slack
import json
from datetime import datetime
import time
arr = []
def symbol_info(req_params, i):
    global arr
    url = "https://api.binance.com/api/v3/ticker/24hr"
    val = requests.get(url,params = req_params)
    try:
        data = json.loads(val.text)
        
        x = arr[i]
        try:
            if float(data["priceChangePercent"])>=x:
                client = slack.WebClient(token = SLACK_TOKEN)
                client.chat_postMessage(channel = "#bot_alerts", 
                        text = f"{datetime.now().strftime('%Y-%m-%d %H:%M:%S')} {data['symbol']} 24Hchange={float(data['priceChangePercent'])}% new benchmark {x+5}%")
                arr[i] = arr[i] + 5
        except:
            pass
    except:
        print("Could not connect")

for i in range(len(crypto_symbols)):
    arr.append(20)

while True:
    for i in range(len(crypto_symbols)):
        today = datetime.now()
        if today.hour + today.minute + today.second == 0:
            for i in range(len(crypto_symbols)):
                arr[i] = 20
        req_params = dict(symbol = crypto_symbols[i] + "USDT")
        thread = threading.Thread(target = symbol_info, args = (req_params,i,))
        thread.start()
    time.sleep(15)
