from transformers import AutoTokenizer, AutoModelForCausalLM, AdapterType, GPT2LMHeadModel
from transformers.adapters import AdapterConfig
import gradio as gr
import torch
import git

device = "cuda" if torch.cuda.is_available() else "cpu"

model_name = "GPT2-xl"
tokenizer = AutoTokenizer.from_pretrained(model_name)
model = AutoModelForCausalLM.from_pretrained(model_name)

git.Repo.clone_from("https://huggingface.co/Celestinian/Nora-Adapter", "Nora")

astraiabv = model.load_adapter("./Nora", config="./Nora/adapter_config.json")
model.set_active_adapters(astraiabv)

def generate_text(prompt, max_length, do_sample, temperature):
    prompt = tokenizer(prompt + " >>>", return_tensors='pt')
    prompt = {key: value.to(device) for key, value in prompt.items()}
    out = model.generate(**prompt, max_length=max_length, do_sample=do_sample, temperature=temperature, no_repeat_ngram_size=3)
    output = tokenizer.decode(out[0])
    clean_output = output.replace('\n', '\n')
    print(clean_output)
    return clean_output

input_text = gr.inputs.Textbox(lines=5, label="Input Text")
max_length_input = gr.inputs.Number(default=30, label="Max Length")
do_sample_input = gr.inputs.Checkbox(default=True, label="Do Sample")
temperature_input = gr.inputs.Slider(minimum=0.01, maximum=1, step=0.01, default=0.04, label="Temperature")

output_text = gr.outputs.Textbox(label="Generated Text")

disclaimer = "Nora, an experimental compact model with 1.5 billion parameters, demonstrates impressive proficiency when it comes to answering questions and executing diverse tasks such as composing poems, songs, and generating lists. It is essential to acknowledge, however, that she is not a conversational model designed for universal purposes and may occasionally produce incorrect information."

gr.Interface(generate_text, inputs=[input_text, max_length_input, do_sample_input, temperature_input], outputs=output_text, description=disclaimer).launch()
