import gradio
import os

from langchain.chains.question_answering import load_qa_chain
from langchain.document_loaders import UnstructuredURLLoader
from langchain import HuggingFaceHub

os.environ["HUGGINGFACEHUB_API_TOKEN"] = "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"

llm = HuggingFaceHub(repo_id="declare-lab/flan-alpaca-large", model_kwargs={"temperature":0.1, "max_length":512})

os.environ["LANGCHAIN_TRACING_V2"] = "true"
os.environ["LANGCHAIN_ENDPOINT"] = "https://api.smith.langchain.com"
os.environ["LANGCHAIN_API_KEY"] = "ls__ae9b316f4ee9475b84f66c616344d713"
os.environ["LANGCHAIN_PROJECT"] = "Sequential-Chain"

def main():

    gradio_interface = gradio.Interface(
    fn = my_inference_function,
    inputs = "text",
    outputs = "text")

    gradio_interface.launch()


def my_inference_function(url):
  loader = UnstructuredURLLoader(urls=[url])
  data = loader.load()
  chain = load_qa_chain(llm=llm, chain_type="stuff")
  response = chain.run(input_documents=data, question="Summarize this article in one paragraph")
  return response

if __name__ == '__main__':
    main()