import gradio as gr
from paintingface import generate

title = "Face from Photo into Handed-paint"
description = "Upload a photo, this Ai will detect and transfer only the main face into cartoon/anime handed-painting style. (If cannot detect a face, try the edit button on the right corner of the picture to crop the photo manually.)"
article = "Examples are from Internet"

Example=[['Example01.jpg'],['Example02.jpg'],['Example03.jpg']]

demo = gr.Interface(
    generate, 
    inputs = [gr.Image(type="pil", label="Upload a photo")],
    outputs= [gr.Image(type="pil", label="Output")],
    title=title,
    description=description,
    article=article,
    examples=Example,
    allow_flagging='never'
    )

demo.launch()

