import gradio as gr
import torch
from PIL import Image
import pandas as pd

model = torch.hub.load('ultralytics/yolov5', 'yolov5s', pretrained=True)

def inference(im):
    results = model(im)
    results._run(render=True)
    text = results.pandas().xyxy[0].round(2)
    counts = text.groupby(['name'])['name'].count()
    return Image.fromarray(results.ims[0]),str(counts)[5:-24]

title = "Count Objects in the picture"
description = "Count objects in picture by Yolov5s model" 
Example=[['test.jpg']]
demo = gr.Interface(inference,
        inputs = [gr.Image(label="Original Image")], 
        outputs = [gr.Image(label="Output Image"),gr.Textbox(label="Count Objects")], 
        title=title, 
        examples=Example,
        description=description)
demo.launch()