from termcolor import colored

def log(text):
    '''The function logs a given text to a file named 'runtime.log'.
    
    Parameters
    ----------
    text
        The text that will be written to the log file.
    
    '''
    print(text, file=open('runtime.log', 'a+'))

# Print iterations progress


def progressbar(iteration, total, prefix='', suffix='', decimals=1, length=100, fill=colored('█', 'green'), print_end="\r"):
    """
    Call in a loop to create terminal progress bar
    @params:
        iteration   - Required  : current iteration (Int)
        total       - Required  : total iterations (Int)
        prefix      - Optional  : prefix string (Str)
        suffix      - Optional  : suffix string (Str)
        decimals    - Optional  : positive number of decimals in percent complete (Int)
        length      - Optional  : character length of bar (Int)
        fill        - Optional  : bar fill character (Str)
        printEnd    - Optional  : end character (e.g. "\r", "\r\n") (Str)
    """
    percent = ("{0:." + str(decimals) + "f}").format(100 * (iteration / float(total)))
    filled_length = int(length * iteration // total)
    bar = fill * filled_length + colored('-', 'red') * (length - filled_length)
    print(f'\r{prefix} [{bar}] {percent}% ({iteration}/{total}) {suffix}', end = print_end)
    # Print New Line on Complete
    if iteration == total: 
        print()