print("Libraries installed succesfully!!!!")

import torch
from transformers import RobertaTokenizerFast, EncoderDecoderModel, AutoTokenizer, AutoModelForSeq2SeqLM
import re
import gradio as gr

from helper_function import *

import numpy as np
from sklearn.feature_extraction.text import CountVectorizer

import spacy
from sentence_transformers import SentenceTransformer
from sklearn.metrics.pairwise import cosine_similarity

import requests
from pathlib import Path

print('Libraries called succesfully!!!!"')



class keyWordExtractor():
    
    def __init__(self, 
                 article_text,
                 similarity_model,
                 n_gram = 1,
                 top_n = 3,
                 french_stopwords = None,
                 ner= None,
                 ):
        self.article_text = article_text
        self.french_stopwords = french_stopwords
        self.candidates = self.count_vectorizer(n_gram)
        self.noun_candidates, self.proper_noun_candidates = self.slice_only_noun_token(ner, self.candidates)
        self.top_n_keywords = self.top_n_extractor(similarity_model, top_n)
    
    def count_vectorizer(self, n_gram):
        n_gram_range = (n_gram, n_gram)
        # Extract candidate words/phrases
        count = CountVectorizer(ngram_range=n_gram_range,
                        stop_words = self.french_stopwords).fit([self.article_text]) #Main change
        candidates = count.get_feature_names_out()

        return candidates

    def slice_only_noun_token(self, ner, token_list):
        """
        Given the tokenized list, this function returns only the "NOUN" token
            Args:
                ner (spacy): The NER class to detect the `token.pos_`
                token_list (list): List of token from the full article
            Returns:
                slice_list (list): List of token containing only "NOUN" part of speech
        """

        noun_slice_list = []
        proper_noun_slice_list = []
        for word_idx in range(len(token_list)):
            doc = ner(token_list[word_idx])

            for token in doc:
                if token.pos_ == 'NOUN':
                    noun_slice_list.append(token.text)
                elif token.pos_ == 'PROPN':
                    proper_noun_slice_list.append(token.text)

        return noun_slice_list, proper_noun_slice_list

    def top_n_extractor(self, model, top_n):
        doc_embedding = model.encode([self.article_text])
        candidate_embeddings = model.encode(self.noun_candidates)
        distances = cosine_similarity(doc_embedding, candidate_embeddings)
        keywords = [self.noun_candidates[index] for index in distances.argsort()[0][-top_n:]]

        return keywords

def clear_input():
    return ("", "")

       
def camembert_generate_summary(article_text):
   inputs = cmb_tokenizer([article_text], padding="max_length", truncation=True,
                          max_length=50,
                          return_tensors="pt")
   input_ids = inputs.input_ids.to(device)
   attention_mask = inputs.attention_mask.to(device)
   output = cmb_model.generate(input_ids, attention_mask=attention_mask, max_length = 50)
   return cmb_tokenizer.decode(output[0], skip_special_tokens=True)

    
def t5_generate_summary(article_text):
    input_ids = t5_tokenizer(
    [WHITESPACE_HANDLER(article_text)],
    return_tensors="pt",
    padding="max_length",
    truncation=True,
    max_length=512)["input_ids"]
    
    output_ids = t5_model.generate(
        input_ids=input_ids,
        max_length=84,
        no_repeat_ngram_size=2,
        num_beams=4
    )[0]
    
    output = t5_tokenizer.decode(
    output_ids,
    skip_special_tokens=True,
    clean_up_tokenization_spaces=False
    )

    return output

    
def summarizer(dropdown_model, article_text):
    """
    Ruturs a summarized version from the full article based on the selected pretrained-model
    """

    if dropdown_model == 'camembert':
        summary = camembert_generate_summary(article_text)

    elif dropdown_model == 'T5':
        summary = t5_generate_summary(article_text)

    return summary
    
def extract_top_3(article):
    nlp = spacy.load("fr_core_news_md")
    # model = SentenceTransformer("dangvantuan/sentence-camembert-large") #

    a= keyWordExtractor(article,
                        n_gram = 1, 
                        top_n = 3,
                        ner = nlp,
                        similarity_model = model)
    keyword = ", ".join(a.top_n_keywords) #to return ['a' , 'b'] >> "a, b"
    proper_nonuns = ", ".join(a.proper_noun_candidates)

    return keyword, proper_nonuns


def runall(dropdown_model, article_text):
    summary = summarizer(dropdown_model, article_text)
    keywords, proper_n = extract_top_3(article_text)

    return summary, keywords, proper_n



#set the device agnostics code
device = 'cuda' if torch.cuda.is_available() else 'cpu'
test_article ="""\"Un nuage de fumée juste après l’explosion, le 1er juin 2019. Une déflagration dans une importante usine d’explosifs du centre de la Russie a fait au moins 79 blessés samedi 1er juin. L’explosion a eu lieu dans l’usine Kristall à Dzerzhinsk, une ville située à environ 400 kilomètres à l’est de Moscou, dans la région de Nijni-Novgorod. « Il y a eu une explosion technique dans l’un des ateliers, suivie d’un incendie qui s’est propagé sur une centaine de mètres carrés », a expliqué un porte-parole des services d’urgence. Des images circulant sur les réseaux sociaux montraient un énorme nuage de fumée après l’explosion. Cinq bâtiments de l’usine et près de 180 bâtiments résidentiels ont été endommagés par l’explosion, selon les autorités municipales. Une enquête pour de potentielles violations des normes de sécurité a été ouverte. Fragments de shrapnel Les blessés ont été soignés après avoir été atteints par des fragments issus de l’explosion, a précisé une porte-parole des autorités sanitaires citée par Interfax. « Nous parlons de blessures par shrapnel d’une gravité moyenne et modérée », a-t-elle précisé. Selon des représentants de Kristall, cinq personnes travaillaient dans la zone où s’est produite l’explosion. Elles ont pu être évacuées en sécurité. Les pompiers locaux ont rapporté n’avoir aucune information sur des personnes qui se trouveraient encore dans l’usine."""

# whitespace handler to be used in `t5 model`
WHITESPACE_HANDLER = lambda k: re.sub('\s+', ' ', re.sub('\n+', ' ', k.strip()))

article_text = """\"Un nuage de fumée juste après l’explosion, le 1er juin 2019. Une déflagration dans une importante usine d’explosifs du centre de la Russie a fait au moins 79 blessés samedi 1er juin. L’explosion a eu lieu dans l’usine Kristall à Dzerzhinsk, une ville située à environ 400 kilomètres à l’est de Moscou, dans la région de Nijni-Novgorod. « Il y a eu une explosion technique dans l’un des ateliers, suivie d’un incendie qui s’est propagé sur une centaine de mètres carrés », a expliqué un porte-parole des services d’urgence. Des images circulant sur les réseaux sociaux montraient un énorme nuage de fumée après l’explosion. Cinq bâtiments de l’usine et près de 180 bâtiments résidentiels ont été endommagés par l’explosion, selon les autorités municipales. Une enquête pour de potentielles violations des normes de sécurité a été ouverte. Fragments de shrapnel Les blessés ont été soignés après avoir été atteints par des fragments issus de l’explosion, a précisé une porte-parole des autorités sanitaires citée par Interfax. « Nous parlons de blessures par shrapnel d’une gravité moyenne et modérée », a-t-elle précisé. Selon des représentants de Kristall, cinq personnes travaillaient dans la zone où s’est produite l’explosion. Elles ont pu être évacuées en sécurité. Les pompiers locaux ont rapporté n’avoir aucune information sur des personnes qui se trouveraient encore dans l’usine."""


cmb_ckpt = 'mrm8488/camembert2camembert_shared-finetuned-french-summarization'
cmb_tokenizer = RobertaTokenizerFast.from_pretrained(cmb_ckpt)
cmb_model = EncoderDecoderModel.from_pretrained(cmb_ckpt).to(device)


t5_model_name = "csebuetnlp/mT5_multilingual_XLSum"
t5_tokenizer = AutoTokenizer.from_pretrained(t5_model_name)
t5_model = AutoModelForSeq2SeqLM.from_pretrained(t5_model_name)

print(summarizer("camembert", test_article))


###
import requests
from pathlib import Path

if Path('french_stopword.txt').is_file():
    print('already exists')
else:
    print('not existed yet')
    request = requests.get("https://raw.githubusercontent.com/stopwords-iso/stopwords-fr/master/stopwords-fr.txt")
    with open('french_stopword.txt', "wb") as f:
        f.write(request.content)


# opening the file in read mode
my_file = open("french_stopword.txt", "r")
  
# reading the file
data = my_file.read()
  
# replacing end of line('/n') with ' ' and
# splitting the text it further when '.' is seen.
french_stopwords_list = data.replace('\n', ' ').split(" ")
  
# # printing the data
print(french_stopwords_list)
my_file.close()

###

nlp = spacy.load("fr_core_news_md")
model =  SentenceTransformer("dangvantuan/sentence-camembert-large")

print(extract_top_3(test_article))

some_examples = [

        ["camembert", """
    Carrefour livraison service honteux ! Ne livre jamais dans les temps, plusieurs heures de retard et si on a le malheur de travailler et de ne pas être chez nous toute la journée on peut dire au revoir à notre commande !
Service client délocalisé qui insulte et raccroche au nez quand on demande ou est notre commande !
Je ne recommande absolument pas, j'ai pourtant laisser plusieurs chance mais à chaque fois extrêmement déçu...
    """],
    ["camembert", """
    Très mauvaise expérience !!!
Commande livré par terre sans rien dire alors que nous étions présents.
En plein centre ville de Dijon.
Merci pour l’hygiène et la compétence du livreur. 
Sans parler des surgelés en plein soleil qui ont finis à la poubelle.
Merci Carrefour Quetigny.
    """]
    
]



###



####

with gr.Blocks() as demo:
    gr.Markdown("Summarize the article text.")

    with gr.Tab("Summarization + Extraction"):
        with gr.Row():
            with gr.Column():
                input_models = gr.Dropdown(['camembert'], value = 'camembert')
                input_article = gr.TextArea(label = 'Article to be summarized')

            with gr.Column():
                summarized_output = gr.TextArea(label= 'Generated summary')
                output_keyword = gr.Textbox(label="Top 3 keywords")
                output_proper_nouns = gr.Textbox(label="Proper Nouns")

        with gr.Row():
            clear_button = gr.Button("Clear")
            summarize_button = gr.Button("Summarize!")
            extract_button = gr.Button("Extract!")
            run_button = gr.Button("Run all!")

        examples = gr.Examples(examples= some_examples,
                                     inputs=[input_models, input_article])


        summarize_button.click(summarizer,
                            inputs = [input_models, input_article] ,
                            outputs = summarized_output)
        

        extract_button.click(extract_top_3,
                            inputs = input_article ,
                            outputs = [output_keyword, output_proper_nouns])
        
        run_button.click(runall,
                         inputs = [input_models, input_article],
                         outputs = [summarized_output, output_keyword, output_proper_nouns ])
        
        clear_button.click(clear_input,
                        outputs = [input_models, input_article])

    with gr.Tab("Summarization"):
        with gr.Row():
            with gr.Column():
                input_models = gr.Dropdown(['camembert', 'T5'])
                input_article = gr.TextArea(label = 'Article to be summarized')
            with gr.Column():
                summarized_output = gr.TextArea(label= 'Generated summa')
        with gr.Row():

            clear_button = gr.Button("Clear")
            summarize_button = gr.Button("Summarize!")
            
        summarize_button.click(summarizer,
                            inputs = [input_models, input_article] ,
                            outputs = summarized_output)
        
        clear_button.click(clear_input,
                        outputs = [input_models, input_article])
    
        example = "Un nuage de fumée juste après l’explosion, le 1er juin 2019. Une déflagration dans une importante usine d’explosifs du centre de la Russie a fait au moins 79 blessés samedi 1er juin. L’explosion a eu lieu dans l’usine Kristall à Dzerzhinsk, une ville située à environ 400 kilomètres à l’est de Moscou, dans la région de Nijni-Novgorod. « Il y a eu une explosion technique dans l’un des ateliers, suivie d’un incendie qui s’est propagé sur une centaine de mètres carrés », a expliqué un porte-parole des services d’urgence. Des images circulant sur les réseaux sociaux montraient un énorme nuage de fumée après l’explosion. Cinq bâtiments de l’usine et près de 180 bâtiments résidentiels ont été endommagés par l’explosion, selon les autorités municipales. Une enquête pour de potentielles violations des normes de sécurité a été ouverte. Fragments de shrapnel Les blessés ont été soignés après avoir été atteints par des fragments issus de l’explosion, a précisé une porte-parole des autorités sanitaires citée par Interfax. « Nous parlons de blessures par shrapnel d’une gravité moyenne et modérée », a-t-elle précisé. Selon des représentants de Kristall, cinq personnes travaillaient dans la zone où s’est produite l’explosion. Elles ont pu être évacuées en sécurité. Les pompiers locaux ont rapporté n’avoir aucune information sur des personnes qui se trouveraient encore dans l’usine."
        examples = gr.Examples(examples=[ ["camembert",example],
                                        ["T5",example]],
                                        inputs=[input_models, input_article])
        
    with gr.Tab("Key word extraction"):
        

        with gr.Row():
            with gr.Column():
                input_article = gr.TextArea(label = 'Article to be extracted')
            with gr.Column():
                output_1 = gr.Textbox(label="Top 3 keywords")
                output_2 = gr.Textbox(label="Proper Nouns")

        with gr.Row():

            clear_button = gr.Button("Clear")
            extract_button = gr.Button("Extract!")

        extract_button.click(extract_top_3,
                            inputs = input_article ,
                            outputs = [output_1, output_2])



demo.launch(debug=True)