import streamlit as st
import base64


PDF_WIDTH = 700
PDF_HEIGHT = 1000
PDF_PATH = "/AI%20ORUS%20License%20(1).pdf"

def display_pdf(file):
    # Opening file from file path
    with open(file, "rb") as f:
        base64_pdf = base64.b64encode(f.read()).decode('utf-8')

    # Embedding PDF in HTML
    pdf_display = F'<iframe src="data:application/pdf;base64,{base64_pdf}" width="{PDF_WIDTH}" height="{PDF_HEIGHT}" type="application/pdf"></iframe>'
    
    # Displaying File
    st.markdown(pdf_display, unsafe_allow_html=True)

st.title("AI Open Responsible Use License - Version 1.0.0")

st.markdown("## Purpose")

st.markdown("This license covers any AI-specific material, such as neural networks or any other type of model, software, data, or other material that is designated as being available under this license. These materials, together, are referred to in this license as licensed materials. This license gives you as much permission as possible to use, share and improve the licensed materials. This license places no limitations on the use of output from any model, or any changes you make to any licensed materials. It should be interpreted to provide you with the maximum possible freedom.")

st.markdown("## License")

st.markdown("Each contributor licenses you to do everything with the licensed materials that would otherwise infringe that contributor’s rights, including without limitation copyright, patent, trade secret rights, and the right to use the data to train models, but only in compliance with applicable law. However, this license grants you no trademark or publicity rights.")

st.markdown("## Indemnity")

st.markdown("If you use the licensed materials in a manner not compliant with applicable law, or that otherwise causes any contributor legal liability relating to your use of the licensed materials, or that damages the reputation of any contributor, you must, as a condition of this license as a promise to each contributor, defend and indemnify every contributor against any resulting losses, damages or costs.")

st.markdown("## No Liability")

st.markdown("As far as the law allows, each licensed material is provided as is, without any warranty or condition, and no contributor will be liable to anyone for any damages related to this any licensed material or this license, under any kind of legal claim.")