from transformers import AutoTokenizer
import gradio as gr
from transformers import XLMRobertaForSequenceClassification
from transformers import pipeline

id2label = {0:'INSULT', 1:'OTHER', 2:'PROFANITY', 3:'RACIST', 4:'SEXIST'}
model = XLMRobertaForSequenceClassification.from_pretrained(".")
tokenizer = AutoTokenizer.from_pretrained(".")

def predict(text):
	classifier = pipeline("text-classification", model=model, tokenizer=tokenizer)
	result = id2label[int(classifier(text)[0]['label'].split('_')[-1])]
	return result

iface = gr.Interface(fn=predict, inputs="text", outputs="text")
iface.launch()
