import torch
from PIL import Image
from torchvision import transforms
import pandas as pd
import numpy as np

from DogBreedClassifier import DogBreedClassifier

import gradio as gr

class_labels = pd.read_csv('stanford dogs breeds')
class_labels = class_labels["breed_names"].tolist()

# LOAD MODEL
dog_model = DogBreedClassifier()
dog_model.load_state_dict(torch.load("model_state_dict.pth", map_location=torch.device("cpu")))

torch.hub.download_url_to_file("https://upload.wikimedia.org/wikipedia/commons/thumb/3/34/Labrador_on_Quantock_%282175262184%29.jpg/1200px-Labrador_on_Quantock_%282175262184%29.jpg", "labrador-retriever.jpeg")
torch.hub.download_url_to_file("https://upload.wikimedia.org/wikipedia/commons/d/d0/German_Shepherd_-_DSC_0346_%2810096362833%29.jpg", "german-shepard.jpeg")
torch.hub.download_url_to_file("https://i.imgur.com/HqlDKO4.jpg", "shiba-ushi.jpeg")


def process_input(image):
	"""image is pil image object"""
	image_transforms = transforms.Compose([transforms.Resize((224, 224)),
										   transforms.ToTensor(),
										   transforms.Normalize([0.485, 0.456, 0.406], [0.229, 0.224, 0.225])
										   ])

	# apply transforms and add batch dimension for model input
	image = image_transforms(image)
	image_input = image.unsqueeze(0)

	return image_input

def predict(inp):

	image_input = process_input(inp)

	dog_model.eval()
	with torch.no_grad():
		prediction = torch.nn.functional.softmax(dog_model(image_input)[0], dim=0)
		confidences = {class_labels[i]: float(prediction[i]) for i in range(len(class_labels))}

	return confidences

# confidences = predict(dog_model, dudley_image)
#
# print(confidences)

gr.Interface(fn=predict,
			 inputs=gr.Image(type="pil"),
			 outputs=gr.Label(num_top_classes=10),
			 examples=["labrador-retriever.jpeg", "german-shepard.jpeg", "shiba-ushi.jpeg"]).launch()