import torchvision
from torch import nn
from torchvision.models import EfficientNet_B0_Weights


def freeze_layers(model):
    """ Freezes model layers by settings requires_grad to False or True. """
    for num_params, param in enumerate(model.parameters()):
        if num_params > 140:
            param.requires_grad = True
        else:
            param.requires_grad = False
        return model


class DogBreedClassifier(nn.Module):
    def __init__(self):
        super(DogBreedClassifier, self).__init__()
        self.resnet = freeze_layers(torchvision.models.efficientnet_b0(weights=EfficientNet_B0_Weights.DEFAULT))

        self.custom_classifier = nn.Sequential(
            nn.Linear(1280, 256),
            nn.ReLU(),
            nn.Dropout(p=0.5),
            nn.Linear(256, 120),
        )

        # replace classifier layers of pretrained model
        self.resnet.classifier = self.custom_classifier

    def forward(self, x):
        x = self.resnet(x)
        return x


if __name__ == '__main__':
    model = DogBreedClassifier()

    print(model)