import gradio as gr
from fastai.vision.all import *

__all__ = ["learn", "classify_image", "categories", "image", "label", "examples", "intf"]

learn = load_learner('export.pkl')

categories = ('Black', 'Grizzly', 'Teddy')

def classify_image(inp):
    pred,idx,probs = learn.predict(inp)
    return dict(zip(categories, map(float, probs)))


image = gr.inputs.Image(shape=(192, 192))
label = gr.outputs.Label()
examples = ["grizzly.jpg", "teddy.jpg"]

iface = gr.Interface(fn=classify_image, inputs=image, outputs=label, examples=examples)
iface.launch(inline=False)
