import gradio as gr
from transformers import pipeline

pipe = pipeline("image-classification", "umm-maybe/AI-image-detector")

def image_classifier(image):
    outputs = pipe(image)
    results = {}
    for result in outputs:
        results[result['label']] = result['score']
    return results

demo = gr.Interface(fn=image_classifier, inputs=gr.Image(type="pil"), outputs="label")
demo.launch()
