import os
import gradio as gr
from pathlib import Path
 	
 	
os.system("git clone https://github.com/YangtaoWANG95/TokenCut.git")
os.chdir("TokenCut")
os.system("wget https://raw.githubusercontent.com/YangtaoWANG95/TokenCut/master/examples/VOC07_000064.jpg -O parrot.jpg")
 	
def inference(img):
    os.system("python main_tokencut.py --image_path "+img+" --visualize all --resize 320")
    filename = Path(img).stem
    return "./outputs/TokenCut-vit_small16_k/"+filename+"_TokenCut_attn.jpg","./outputs/TokenCut-vit_small16_k/"+filename+"_TokenCut_pred.jpg"
  
title="TokenCut"
description="Gradio demo for TokenCut: Self-Supervised Transformers for Unsupervised Object Discovery using Normalized Cut. To use it, simply upload your image or click on one of the examples to load them. We resize the smaller edge of the image to 320 to accelerate inference time. Read more at the links below"

article = "<p style='text-align: center'><a href='https://arxiv.org/abs/2202.11539' target='_blank'>Self-Supervised Transformers for Unsupervised Object Discovery using Normalized Cut</a> | <a href='https://github.com/YangtaoWANG95/TokenCut' target='_blank'>Github Repo</a></p>"

examples=[['parrot.jpg']]
gr.Interface(inference,gr.inputs.Image(type="filepath"),[gr.outputs.Image(type="filepath",label="TokenCut_attn"),gr.outputs.Image(type="filepath",label="TokenCut_predication")],title=title,description=description,article=article,examples=examples).launch(enable_queue=True)

