import os
import requests
import pandas as pd
import gradio as gr
from huggingface_hub.hf_api import SpaceInfo
from pathlib import Path


path = f"https://huggingface.co/api/spaces"
os.system("git clone https://github.com/YangtaoWANG95/TokenCut.git")
os.chdir("TokenCut")
os.system("wget https://raw.githubusercontent.com/YangtaoWANG95/TokenCut/master/examples/VOC07_000064.jpg -O parrot.jpg")
 	

    
def get_blocks_party_spaces():
    r = requests.get(path)
    d = r.json()
    spaces = [SpaceInfo(**x) for x in d]
    blocks_spaces = {}
    for i in range(0,len(spaces)):
        if spaces[i].id.split('/')[0] == 'CVPR' and hasattr(spaces[i], 'likes') and spaces[i].id != 'CVPR/Leaderboard' and spaces[i].id != 'CVPR/README':
            blocks_spaces[spaces[i].id]=spaces[i].likes
    df = pd.DataFrame(
    [{"Spaces_Name": Spaces, "likes": likes} for Spaces,likes in blocks_spaces.items()])
    df = df.sort_values(by=['likes'],ascending=False)
    return df


block = gr.Blocks()

with block:    
    gr.Markdown("""Leaderboard for the most popular CVPR Spaces. To learn more and join, see <a href="https://huggingface.co/CVPR" target="_blank" style="text-decoration: underline">CVPR Event</a>""")
    with gr.Tabs():
        with gr.TabItem("CVPR Leaderboard"):
            with gr.Row():
                data = gr.outputs.Dataframe(type="pandas")
            with gr.Row():
                data_run = gr.Button("Refresh")
                data_run.click(get_blocks_party_spaces, inputs=None, outputs=data)

    block.load(get_blocks_party_spaces, inputs=None, outputs=data)                
block.launch()
