import os
# os.system('sudo apt-get install python3-dev')
os.system('python setup.py install --user')
import argparse
import csv
import numpy as np
import sys
sys.path.append("/home/user/.local/lib/python3.8/site-packages/diffvg-0.0.1-py3.8-linux-x86_64.egg")
print(sys.path)
from pathlib import Path

import gradio as gr

import torch
import yaml
from PIL import Image
from subprocess import call
import torch
import cv2
import matplotlib.pyplot as plt
import random
import argparse
import math
import errno
from tqdm import tqdm
import yaml
from easydict import EasyDict as edict


def run_cmd(command):
    try:
        print(command)
        call(command, shell=True)
    except KeyboardInterrupt:
        print("Process interrupted")
        sys.exit(1)
# run_cmd("gcc --version")
# run_cmd("pwd")
# run_cmd("ls")
# run_cmd("git submodule update --init --recursive")
# run_cmd("python setup.py install --user")
# run_cmd("pip3 list")
# import pydiffvg
#
# print("Sccuessfuly import diffvg ")
# run_cmd("pwd")
# run_cmd("ls")
# run_cmd("git submodule update --init --recursive")
# run_cmd("python setup.py install --user")

# run_cmd("python main.py --config config/base.yaml --experiment experiment_5x1 --signature smile --target figures/smile.png --log_dir log/")
from main import main_func


def parse_args():
    parser = argparse.ArgumentParser()
    parser.add_argument('--debug', action='store_true', default=False)
    parser.add_argument("--config", default="config/base.yaml", type=str)
    parser.add_argument("--experiment", type=str)
    parser.add_argument("--seed", type=int)
    parser.add_argument("--target", type=str, help="target image path")
    parser.add_argument('--log_dir', metavar='DIR', default="log/")
    parser.add_argument('--initial', type=str, default="random", choices=['random', 'circle'])
    parser.add_argument('--signature', default="demo", nargs='+', type=str)
    parser.add_argument('--seginit', nargs='+', type=str)
    parser.add_argument("--num_segments", type=int, default=4)
    # parser.add_argument("--num_paths", type=str, default="1,1,1")
    # parser.add_argument("--num_iter", type=int, default=500)
    # parser.add_argument('--free', action='store_true')
    # Please ensure that image resolution is divisible by pool_size; otherwise the performance would drop a lot.
    # parser.add_argument('--pool_size', type=int, default=40, help="the pooled image size for next path initialization")
    # parser.add_argument('--save_loss', action='store_true')
    # parser.add_argument('--save_init', action='store_true')
    # parser.add_argument('--save_image', action='store_true')
    # parser.add_argument('--save_video', action='store_true')
    # parser.add_argument('--print_weight', action='store_true')
    # parser.add_argument('--circle_init_radius',  type=float)
    cfg = edict()
    args = parser.parse_args()
    cfg.debug = args.debug
    cfg.config = args.config
    cfg.experiment = args.experiment
    cfg.seed = args.seed
    cfg.target = args.target
    cfg.log_dir = args.log_dir
    cfg.initial = args.initial
    cfg.signature = args.signature
    # set cfg num_segments in command
    cfg.num_segments = args.num_segments
    if args.seginit is not None:
        cfg.seginit = edict()
        cfg.seginit.type = args.seginit[0]
        if cfg.seginit.type == 'circle':
            cfg.seginit.radius = float(args.seginit[1])
    return cfg


def app_experiment_change(experiment_id):
    if experiment_id == "add [1] total 1 path for demonstration":
        return "experiment_1x1"
    if experiment_id == "add [1, 1, 1, 1, 1] total 5 paths one by one":
        return "experiment_5x1"
    elif experiment_id == "add [1, 1, 1, 1, 1, 1, 1, 1] total 8 paths one by one":
        return "experiment_8x1"
    elif experiment_id == "add [1,2,4,8,16,32, ...] total 128 paths":
        return "experiment_exp2_128"
    elif experiment_id == "add [1,2,4,8,16,32, ...] total 256 paths":
        return "experiment_exp2_256"


cfg_arg = parse_args()
temp_image = np.random.rand(224,224,3)
temp_text = "start"
temp_input = np.random.rand(224,224,3)
def run_live(img, experiment_id, num_iter, cfg_arg=cfg_arg):
    experiment = app_experiment_change(experiment_id)
    cfg_arg.target = img
    cfg_arg.experiment = experiment
    img, text = main_func(img, experiment_id, num_iter, cfg_arg=cfg_arg)
    return img, text









# ROOT_PATH = sys.path[0]  # 根目录
# # 模型路径
# model_path = "ultralytics/yolov5"
# # 模型名称临时变量
# model_name_tmp = ""
# # 设备临时变量
# device_tmp = ""
# # 文件后缀
# suffix_list = [".csv", ".yaml"]
# def parse_args(known=False):
#     parser = argparse.ArgumentParser(description="Gradio LIVE")
#     parser.add_argument(
#         "--model_name", "-mn", default="yolov5s", type=str, help="model name"
#     )
#     parser.add_argument(
#         "--model_cfg",
#         "-mc",
#         default="./model_config/model_name_p5_all.yaml",
#         type=str,
#         help="model config",
#     )
#     parser.add_argument(
#         "--cls_name",
#         "-cls",
#         default="./cls_name/cls_name.yaml",
#         type=str,
#         help="cls name",
#     )
#     parser.add_argument(
#         "--nms_conf",
#         "-conf",
#         default=0.5,
#         type=float,
#         help="model NMS confidence threshold",
#     )
#     parser.add_argument(
#         "--nms_iou", "-iou", default=0.45, type=float, help="model NMS IoU threshold"
#     )
#
#     parser.add_argument(
#         "--label_dnt_show",
#         "-lds",
#         action="store_false",
#         default=True,
#         help="label show",
#     )
#     parser.add_argument(
#         "--device",
#         "-dev",
#         default="cpu",
#         type=str,
#         help="cuda or cpu, hugging face only cpu",
#     )
#     parser.add_argument(
#         "--inference_size", "-isz", default=640, type=int, help="model inference size"
#     )
#
#     args = parser.parse_known_args()[0] if known else parser.parse_args()
#     return args
# #  模型加载
# def model_loading(model_name, device):
#
#     # 加载本地模型
#     model = torch.hub.load(model_path, model_name, force_reload=True, device=device)
#
#     return model
# # 检测信息
# def export_json(results, model, img_size):
#
#     return [
#         [
#             {
#                 "id": int(i),
#                 "class": int(result[i][5]),
#                 "class_name": model.model.names[int(result[i][5])],
#                 "normalized_box": {
#                     "x0": round(result[i][:4].tolist()[0], 6),
#                     "y0": round(result[i][:4].tolist()[1], 6),
#                     "x1": round(result[i][:4].tolist()[2], 6),
#                     "y1": round(result[i][:4].tolist()[3], 6),
#                 },
#                 "confidence": round(float(result[i][4]), 2),
#                 "fps": round(1000 / float(results.t[1]), 2),
#                 "width": img_size[0],
#                 "height": img_size[1],
#             }
#             for i in range(len(result))
#         ]
#         for result in results.xyxyn
#     ]
# def yolo_det(img, experiment_id, device=None, model_name=None, inference_size=None, conf=None, iou=None, label_opt=None, model_cls=None):
#
#     global model, model_name_tmp, device_tmp
#
#     if model_name_tmp != model_name:
#         # 模型判断，避免反复加载
#         model_name_tmp = model_name
#         model = model_loading(model_name_tmp, device)
#     elif device_tmp != device:
#         device_tmp = device
#         model = model_loading(model_name_tmp, device)
#
#     # -----------模型调参-----------
#     model.conf = conf  # NMS 置信度阈值
#     model.iou = iou  # NMS IOU阈值
#     model.max_det = 1000  # 最大检测框数
#     model.classes = model_cls  # 模型类别
#
#     results = model(img, size=inference_size)  # 检测
#     results.render(labels=label_opt)  # 渲染
#
#     det_img = Image.fromarray(results.imgs[0])  # 检测图片
#
#     det_json = export_json(results, model, img.size)[0]  # 检测信息
#
#     return det_img, det_json


# def run_cmd(command):
#     try:
#         print(command)
#         call(command, shell=True)
#     except KeyboardInterrupt:
#         print("Process interrupted")
#         sys.exit(1)
#
# run_cmd("gcc --version")
# run_cmd("pwd")
# run_cmd("ls")
# run_cmd("git submodule update --init --recursive")
# run_cmd("python setup.py install --user")
# run_cmd("ls")
# run_cmd("python main.py --config config/base.yaml --experiment experiment_5x1 --signature smile --target figures/smile.png --log_dir log/")






# # yaml文件解析
# def yaml_parse(file_path):
#     return yaml.safe_load(open(file_path, "r", encoding="utf-8").read())
#
#
# # yaml csv 文件解析
# def yaml_csv(file_path, file_tag):
#     file_suffix = Path(file_path).suffix
#     if file_suffix == suffix_list[0]:
#         # 模型名称
#         file_names = [i[0] for i in list(csv.reader(open(file_path)))]  # csv版
#     elif file_suffix == suffix_list[1]:
#         # 模型名称
#         file_names = yaml_parse(file_path).get(file_tag)  # yaml版
#     else:
#         print(f"{file_path}格式不正确！程序退出！")
#         sys.exit()
#
#     return file_names


def main(args):
    gr.close_all()
    # -------------------Inputs-------------------
    inputs_iteration = gr.inputs.Slider(
        label="Optimization Iteration",
        default=500, maximum=600, minimum=100, step=100)
    inputs_img = gr.inputs.Image(type="pil", label="Input Image", shape=[160, 160])
    experiment_id = gr.inputs.Radio(
        choices=[
            "add [1] total 1 path for demonstration",
            "add [1, 1, 1, 1, 1] total 5 paths one by one",
            "add [1, 1, 1, 1, 1, 1, 1, 1] total 8 paths one by one",
            "add [1,2,4,8,16,32, ...] total 128 paths",
            "add [1,2,4,8,16,32, ...] total 256 paths"], type="value", default="add [1, 1, 1, 1, 1] total 5 paths one by one", label="Path Adding Scheduler"
    )

    # inputs
    inputs = [

        inputs_img,  # input image
        experiment_id, # path adding scheduler
        inputs_iteration, # input iteration

    ]
    # outputs
    outputs = gr.outputs.Image(type="numpy", label="Vectorized Image")
    outputs02 = gr.outputs.File(label="Generated SVG output")

    # title
    title = "LIVE: Towards Layer-wise Image Vectorization"
    # description
    description = "<div align='center'>(CVPR 2022 Oral Presentation)</div>" \
                  "<div align='center'>For efficiency, we rescale input to 160x160 (smaller size and fewer iterations will decrease the reconstructions).</div> "
    article = "<p style='text-align: center'><a href='https://ma-xu.github.io/LIVE/' target='_blank'>Towards Layer-wise Image Vectorization</a> | <a href='https://github.com/Picsart-AI-Research/LIVE-Layerwise-Image-Vectorization' target='_blank'>Github Repo</a></p><center><img src='https://visitor-badge.glitch.me/badge?page_id=Picsart-AI-Research.LIVE-Layerwise-Image-Vectorization' alt='visitor badge'></center>"

    # examples
    examples = [
        [
            "./examples/1.png",
            "add [1] total 1 path for demonstration",
            100,
        ],
        [
            "./examples/2.png",
            "add [1, 1, 1, 1, 1] total 5 paths one by one",
            300,
        ],
        [
            "./examples/3.jpg",
            "add [1,2,4,8,16,32, ...] total 128 paths",
            300,
        ],
        [
            "./examples/4.png",
            "add [1,2,4,8,16,32, ...] total 256 paths",
            300,
        ],
        [
            "./examples/5.png",
            "add [1, 1, 1, 1, 1] total 5 paths one by one",
            300,
        ],
    ]

    # Interface
    gr.Interface(
        fn=run_live,
        inputs=inputs,
        outputs=[outputs, outputs02],
        title=title,
        description=description,
        article=article,
        examples=examples,
        theme="seafoam",
        # live=True, # 实时变更输出
        flagging_dir="log"  # 输出目录
        # ).launch(inbrowser=True, auth=['admin', 'admin'])
    ).launch(
        inbrowser=True,  # 自动打开默认浏览器
        show_tips=True,  # 自动显示gradio最新功能
        enable_queue=True
        # favicon_path="./icon/logo.ico",
    )


if __name__ == "__main__":
    args = parse_args()
    main(args)
