#!/usr/bin/env python

from __future__ import annotations

import gradio as gr

from paper_list import PaperList

DESCRIPTION = '# CVPR 2022 Papers'
NOTES = '''
- [CVPR 2022](https://cvpr2022.thecvf.com/)
- [Proceedings](https://openaccess.thecvf.com/CVPR2022)
'''

paper_list = PaperList()

with gr.Blocks(css='style.css') as demo:
    gr.Markdown(DESCRIPTION)

    search_box = gr.Textbox(
        label='Search Title',
        placeholder=
        'You can search for titles with regular expressions. e.g. (?<!sur)face'
    )
    case_sensitive = gr.Checkbox(label='Case Sensitive')
    filter_names = gr.CheckboxGroup(label='Filter',
                                    choices=[
                                        'Supp',
                                        'arXiv',
                                        'GitHub',
                                        'HF Space',
                                        'HF Model',
                                        'HF Dataset',
                                    ])
    search_button = gr.Button('Search')

    number_of_papers = gr.Textbox(label='Number of Papers Found')
    table = gr.HTML(show_label=False)

    gr.Markdown(NOTES)

    demo.load(
        fn=paper_list.render,
        inputs=[
            search_box,
            case_sensitive,
            filter_names,
        ],
        outputs=[
            number_of_papers,
            table,
        ],
    )
    search_button.click(
        fn=paper_list.render,
        inputs=[
            search_box,
            case_sensitive,
            filter_names,
        ],
        outputs=[
            number_of_papers,
            table,
        ],
    )
demo.queue().launch()
