import gradio as gr
import arxiv
from datasets import load_dataset
import os

search = arxiv.Search(
    query = "cs.LG",
    max_results = 50,
    sort_by = arxiv.SortCriterion.SubmittedDate
)

def hf_data_upload(user_id, paper_id, feedback):
  new_row = {"user_id": user_id, "paper_id": paper_id, "feedback": feedback}
  print("Do nothing")
  return 0

with gr.Blocks() as demo:
  gr.Markdown("<center><h1>My ArXiv</h1></center>")
  user_id = gr.Textbox(placeholder="Enter user id for personalization: ")
  with gr.Column():
    for arxiv_paper in search.results():
      temp_id = arxiv_paper.entry_id
      temp_id = temp_id.split("/")[-1]
      temp_id = temp_id.replace(".", "").replace("v1", "")
      temp_id = int(temp_id)
      with gr.Column():
        with gr.Column():
          gr.Markdown("<center><h3>" + arxiv_paper.title + "</h3></center>")
          gr.Markdown(arxiv_paper.summary)
        with gr.Row():
          more_button = gr.Button("More like this! 😎")
          # add user id value later
          #more_button.click(hf_data_upload(0, temp_id, 1))
          #button.click(flip_image, inputs=image_input, outputs=image_output)
          less_button = gr.Button("Less like this! 😕")
          #less_button.click(hf_data_upload(0, temp_id, 0))

demo.launch()