import openai
import os 
import os.path
import gradio
from datetime import date
from datetime import datetime
import _thread 

# import the prompts here:
from prompts import debate_prompt_1


#########################################

openai.api_key = os.getenv("OPENAI_API_KEY")

print("OPENAI_API_KEY Working...\n")

users = {(os.getenv("user1"), os.getenv("PASSWORD")),(os.getenv("user2"), os.getenv("PASSWORD")), 
        (os.getenv("user3"), os.getenv("PASSWORD")),(os.getenv("user4"), os.getenv("PASSWORD")),
        (os.getenv("user5"), os.getenv("PASSWORD")),(os.getenv("user6"), os.getenv("PASSWORD")), 
        (os.getenv("user7"), os.getenv("PASSWORD")),(os.getenv("user8"), os.getenv("PASSWORD")),
        (os.getenv("user9"), os.getenv("PASSWORD")),(os.getenv("user10"), os.getenv("PASSWORD")), 
        (os.getenv("user11"), os.getenv("PASSWORD")),(os.getenv("user12"), os.getenv("PASSWORD")),
        (os.getenv("user13"), os.getenv("PASSWORD")),(os.getenv("user14"), os.getenv("PASSWORD")), 
        (os.getenv("user15"), os.getenv("PASSWORD")),(os.getenv("user16"), os.getenv("PASSWORD")),
        (os.getenv("user17"), os.getenv("PASSWORD")),(os.getenv("user18"), os.getenv("PASSWORD"))}

currentUsers = []
user_num = -1

def authorization(username, password):
    if (username, password) in users: 
        currentUsers.append(username)
        global user_num 
        user_num += 1
        print(currentUsers, user_num)
        return True
    else:
        return False 


# now = datetime.now()
today = date.today()
# start_time = now.strftime("%H:%M:%S")

output = []

############## STREAMING VERSION W/O FLAGGING ##################################

def predict(message, history):
    history_openai_format = [{"role": "system", "content": debate_prompt_1}]

    for human, assistant in history:
        history_openai_format.append({"role": "user", "content": human })
        history_openai_format.append({"role": "assistant", "content":assistant})
        output.append(f"{currentUsers[0]}: {human}\n\n")
        output.append(f"gpt-4: {assistant}\n\n")
    history_openai_format.append({"role": "user", "content": message})

    # print(currentUsers[user_num])
    # with open(f'activity/{currentUsers[user_num]}_({today}).txt', 'w') as f:
    #     if (len(output) > 2): 
    #         f.write(f"{output[-2]}\n\n")
    #         f.write(f"{output[-1]}\n\n")

    response = openai.ChatCompletion.create(
        model='gpt-4',
        messages= history_openai_format,
        temperature=0.8,
        max_tokens=512,
        top_p=1,
        stream=True
    )

    partial_message = ""
    for chunk in response:
        if len(chunk['choices'][0]['delta']) != 0:
            partial_message = partial_message + chunk['choices'][0]['delta']['content']
            yield partial_message

    # if message == 'exit': 
    #     _thread.interrupt_main()

gradio.ChatInterface(fn = predict, 
                     title = "80-100 Pre-Writing AI Assistant Chatbot", 
                     description = "Welcome to the 80-100 Pre-Writing AI Chatbot.\n This bot is designed to discuss the readings, create outlines, and a variety of pre-writing tasks.\nRemember to copy and paste your interaction to a document. Conversations are not saved.\n Please start the discussion by asking: What is your job?",
                     
).queue().launch(auth = authorization)

################################################################################

# today = date.today()
# now2 = datetime.now()
# end_time = now2.strftime("%H:%M:%S")

# addition = ""

# if (os.path.isfile(f'activity/{currentUsers[0]}_({today}).txt')):
#     counter = 1 
#     addition = f"-{counter}"
#     while(os.path.isfile(f'activity/{currentUsers[0]}_({today}){addition}.txt')):
#         counter += 1
#         addition = f"-{counter}"

# with open(f'activity/{currentUsers[0]}_({today}){addition}.txt', 'w') as f:
#     f.write(f"Start of Session: {start_time} \n")
#     f.write(f"End of Session: {end_time} \n\n")
#     f.writelines(output)
#     f.write('------End of Session------')

# print("Activity has been logged in the history folder. Have a nice day!")
