import gradio as gr
from transformers import pipeline

app = gr.Blocks()

model_id_1 = "nlptown/bert-base-multilingual-uncased-sentiment"
model_id_2 = "microsoft/deberta-xlarge-mnli"
model_id_3 = "distilbert-base-uncased-finetuned-sst-2-english"
model_id_4 = "lordtt13/emo-mobilebert"
model_id_5 = "juliensimon/reviews-sentiment-analysis"
model_id_6 = "sbcBI/sentiment_analysis_model"

def parse_output(output_json):  
    list_pred=[]
    for i in range(len(output_json[0])):
        label = output_json[0][i]['label']
        score = output_json[0][i]['score']
        list_pred.append((label, score))
    return list_pred

def get_prediction(model_id):

    classifier = pipeline("text-classification", model=model_id, return_all_scores=True)
             
    def predict(review):
            prediction = classifier(review)
            print(prediction)
            return parse_output(prediction)
    return predict

with app:
    gr.Markdown(
    """
    # Compare Sentiment Analysis Models 
    
    Type text to predict sentiment.
    """)   
    with gr.Row():
        inp_1= gr.Textbox(label="Type text here.",placeholder="The customer service was satisfactory.")
    gr.Markdown(
    """
    **Model Predictions**
    """)
    with gr.Row():
        with gr.Column():
            gr.Markdown(
            """
            Model 1 = nlptown/bert-base-multilingual-uncased-sentiment
            """)
            btn1 = gr.Button("Predict - Model 1")
            gr.Markdown(
            """
            Model 2 = microsoft/deberta-xlarge-mnli
            """)
            btn2 = gr.Button("Predict - Model 2")
            gr.Markdown(
            """
            Model 3 = distilbert-base-uncased-finetuned-sst-2-english"
            """)
            btn3 = gr.Button("Predict - Model 3")
            gr.Markdown(
            """
            Model 4 = lordtt13/emo-mobilebert
            """)
            btn4 = gr.Button("Predict - Model 4")
            gr.Markdown(
            """
            Model 5 = juliensimon/reviews-sentiment-analysis
            """)
            btn5 = gr.Button("Predict - Model 5")
            gr.Markdown(
            """
            Model 6 = sbcBI/sentiment_analysis_model
            """)
            btn6 = gr.Button("Predict - Model 6")

        with gr.Column():
            out_1 = gr.Textbox(label="Predictions for Model 1")
            out_2 = gr.Textbox(label="Predictions for Model 2")  
            out_3 = gr.Textbox(label="Predictions for Model 3")        
            out_4 = gr.Textbox(label="Predictions for Model 4")     
            out_5 = gr.Textbox(label="Predictions for Model 5")  
            out_6 = gr.Textbox(label="Predictions for Model 6")

        btn1.click(fn=get_prediction(model_id_1), inputs=inp_1, outputs=out_1)
        btn2.click(fn=get_prediction(model_id_2), inputs=inp_1, outputs=out_2)
        btn3.click(fn=get_prediction(model_id_3), inputs=inp_1, outputs=out_3)
        btn4.click(fn=get_prediction(model_id_4), inputs=inp_1, outputs=out_4)
        btn5.click(fn=get_prediction(model_id_5), inputs=inp_1, outputs=out_5)
        btn6.click(fn=get_prediction(model_id_6), inputs=inp_1, outputs=out_6)
        
app.launch()