import gradio as gr
import os
import sys
import gensim
import pandas as pd

from huggingface_hub import hf_hub_download
file_path = hf_hub_download("CC26011988/lib_repo", "coa_funcs.py", repo_type="model", use_auth_token=os.environ['TOKEN'])
sys.path.append(os.path.dirname(file_path))
import coa_funcs as coa

def run_coa(t1, t2, ex1, ex2):

    # Trace problems if needed
    if True:
        f = open("diagnostics.txt", "a")
        file_path = os.path.abspath("diagnostics.txt")
        print(file_path)
        f.write("New run **********************************************")
        f.write(t1 + '\n**********' + t2 + '\n**********' + ex1 +'\n**********' + ex2)
        f.close()

    results=coa.do_coa(t1, t2, ex1.split(), ex2.split())
    
    opps='<b><p style="text-align:center; font-size: 24px; color: rgb(0, 100, 0, 0.8);">'

    for s in results:
        print(s[0], '<-', s[2], '->', s[1])
        if s[2]>0:
            opps = opps + str(s[0]) + ' <---- ' + str(s[2]) + ' ----> ' + str(s[1]) + '<br/><br/>'

    # opps=tabulate(results, tablefmt='html')
    
    df = pd.DataFrame.from_records(results,columns=['Object1', 'Object2', 'Opposition_Score'])

    rps_1 = list(set(df['Object1'].tolist()))
    rps1_formatted = '<b><p style="text-align:center; font-size: 24px; color: rgb(100, 0, 0, 0.8);">'
    for r in rps_1:
        rps1_formatted = rps1_formatted  + r + '<br/><br/>'

    rps_2 = list(set(df['Object2'].tolist()))
    rps2_formatted = '<b><p style="text-align:center; font-size: 24px; color: rgb(0, 0, 100, 0.8);">'
    for r in rps_2:
        rps2_formatted = rps2_formatted  + r + '<br/><br/>'       
    
    return opps, df, rps1_formatted, rps2_formatted

with open("long_eg1.txt") as f:
   long_eg1 = f.read()

with open("long_eg2.txt") as f:
    long_eg2 = f.read()

with gr.Blocks() as demo:

    with gr.Row(): # Inputs
        
        decorative=gr.HTML('<b><br/><br/><p style="text-align:center; font-size: 24px;">Computational Semiotics - Opposition Analysis Demo<br/><br/></p></b>')

    with gr.Row():
            
        text1_proxy = gr.Textbox(lines=5, value="", label="Object 1 Text")

        inbtw = gr.Button("Compute Oppositions (Scroll down for results)").style(full_width=False)
              
        text2_proxy = gr.Textbox(lines=5, value="", label="Object 2 Text")
    
    with gr.Row(): # Inputs
        
        text1 = gr.Textbox(value="", label="Filter these words from Text 1:")   

        spacer=gr.HTML('''<p>Based on the research paper "Computational opposition analysis using word embeddings" by Cameron Shackell and Laurianne Sitbon published in
        <i>Argument & Computation</i> available <a href="https://content.iospress.com/articles/argument-and-computation/aac190467" style="color:blue;">here.</a> Please contact Cameron Shackell at the listed email for further information.
        <br/><br/><b>Opposition analysis</b> is useful in understanding audience thinking around topics and has applications in naming, marketing, and brand positioning.''')
        
        text2 = gr.Textbox(value="", label="Filter these words from Text 2")

    #########################################   
    examples = gr.Examples(examples=[["Pepsi tastes sweeter.", 'Pepsi',"Coke tastes saltier.", 'Coke'], ["Tesla offer such beautiful engineering and tech. It was expensive but I love my Tesla.", 'Tesla', "Subaru make safe, reliable, affordable vehicles. I made a smart choice to invest in a Subaru!", 'Subaru'],[long_eg1,'treat',long_eg2,'use']],inputs=[ text1_proxy, text1, text2_proxy, text2], label="Click a row below to load example values")
    ###########################################
    
    # drop3 = gr.Dropdown(["a", "b", "c"], label="Similarity model")
                     
    with gr.Row(): # Outputs 

        results_title=gr.HTML('<br/><br/><p style="text-align:center; font-size: 20px;">Object 1 is more about...<br/><br/></p>')
        results_title=gr.HTML('<br/><br/><p style="text-align:center; font-size: 20px;">Oppositions<br/><br/></p></b>')
        results_title=gr.HTML('<br/><br/><p style="text-align:center; font-size: 20px;">Object 2 is more about...<br/><br/></p>')
        
    with gr.Row():
        
        res_rps_1 = gr.HTML(label="")
        
        opps = gr.HTML(label="") # gr.Textbox(lines=10, placeholder="results", label="RPS 1")

        res_rps_2 = gr.HTML(label="")

    with gr.Row(): # Outputs
        full_results=gr.Dataframe(row_count = (1, "dynamic"), col_count=(3, "fixed"), label='Full results')
        # gr.Label(num_top_classes=4)

    inbtw.click(fn=run_coa, inputs=[text1_proxy, text2_proxy, text1, text2], outputs=[opps, full_results, res_rps_1, res_rps_2])
    
    
demo.launch()