disease_descriptors_chexpert = {
    "No Finding": [
        "Clear lung fields",
        "Normal heart size and shape",
        "No Abnormal fluid buildup",
        "No Visible tumors or masses",
        "No Signs of bone fractures or dislocations"
    ],
    "Enlarged Cardiomediastinum": [
        "Increased width of the heart shadow",
        "Widened mediastinum",
        "Abnormal contour of the heart border",
        "Fluid or air within the pericardium",
        "Mass within the mediastinum",
    ],
    "Cardiomegaly": [
        "Increased size of the heart shadow",
        "Enlargement of the heart silhouette",
        "Increased diameter of the heart border",
        "Increased cardiothoracic ratio",
    ],
    "Lung Opacity": [
        "Increased density in the lung field",
        "Whitish or grayish area in the lung field",
        "Obscured or blurred margins of the lung field",
        "Loss of normal lung markings within the opacity",
        "Air bronchograms within the opacity",
        "Fluid levels within the opacity",
        "Silhouette sign loss with adjacent structures",

    ],
    "Lung Lesion": [
        "Consolidation of lung tissue",
        "Pleural effusion",
        "Cavities or abscesses in the lung",
        "Abnormal opacity or shadow in the lung",
        "Irregular or blurred margins of the lung",

    ],
    "Edema": [
        "Blurry vascular markings in the lungs",
        "Enlarged heart",
        "Kerley B lines",
        "Increased interstitial markings in the lungs",
        "Widening of interstitial spaces",
    ],
    "Consolidation": [
        "Loss of lung volume",
        "Increased density of lung tissue",
        "Obliteration of the diaphragmatic silhouette",
        "Presence of opacities",
    ],
    "Pneumonia": [
        "Consolidation of lung tissue",
        "Air bronchograms",
        "Cavitation",
        "Interstitial opacities",
    ],
    "Atelectasis": [
        "Increased opacity",
        "Volume loss of the affected lung region",
        "Blunting of the costophrenic angle",
        "Shifting of the mediastinum",
      ],
      "Pneumothorax": [
        "Tracheal deviation",
        "Deep sulcus sign",
        "Increased radiolucency",
        "Flattening of the hemidiaphragm",
        "Absence of lung markings",
        "Shifting of the mediastinum"
      ],
      "Pleural Effusion": [
        "Blunting of costophrenic angles",
        "Opacity in the lower lung fields",
        "Mediastinal shift",
        "Reduced lung volume",
        "Presence of meniscus sign or veil-like appearance"
      ],
      "Pleural Other": [
        "Pleural thickening",
        "Pleural calcification",
        "Pleural masses or nodules",
        "Pleural empyema",
        "Pleural fibrosis",
        "Pleural adhesions"
      ],
      "Fracture": [
        "Visible breaks in the continuity of the bone",
        "Misalignments of bone fragments",
        "Displacements of bone fragments",
        "Disruptions of the cortex or outer layer of the bone",
        "Visible callus or healing tissue",
        "Fracture lines that are jagged or irregular in shape",
        "Multiple fracture lines that intersect at different angles"
      ],
      "Support Devices": [
        "Artificial joints or implants",
        "Pacemakers or cardiac devices",
        "Stents or other vascular devices",
        "Prosthetic devices or limbs",
        "Breast implants",
        "Radiotherapy markers or seeds"
      ]
    }

disease_descriptors_chestxray14 = {

    "No Finding": ["No Finding"],
    "Cardiomegaly": [
        "Increased size of the heart shadow",
        "Enlargement of the heart silhouette",
        "Increased diameter of the heart border",
        "Increased cardiothoracic ratio"
    ],
    "Edema": [
        "Blurry vascular markings in the lungs",
        "Kerley B lines",
        "Increased interstitial markings in the lungs",
        "Widening of interstitial spaces"
    ],
    "Consolidation": [
        "Loss of lung volume",
        "Increased density of lung tissue",
        "Obliteration of the diaphragmatic silhouette",
        "Presence of opacities"
    ],
    "Pneumonia": [
        "Consolidation of lung tissue",
        "Air bronchograms",
        "Cavitation",
        "Interstitial opacities"
    ],
    "Atelectasis": [
        "Increased opacity",
        "Volume loss of the affected lung region",
        "Displacement of the diaphragm",
        "Blunting of the costophrenic angle",
        "Shifting of the mediastinum"
      ],
    "Pneumothorax": [
        "Tracheal deviation",
        "Deep sulcus sign",
        "Increased radiolucency",
        "Flattening of the hemidiaphragm",
        "Absence of lung markings",
        "Shifting of the mediastinum"
      ],
    "Pleural Effusion": [
        "Blunting of costophrenic angles",
        "Opacity in the lower lung fields",
        "Mediastinal shift",
        "Reduced lung volume",
        "Meniscus sign or veil-like appearance"
      ],
    "Infiltration": [
        "Irregular or fuzzy borders around white areas",
        "Blurring",
        "Hazy or cloudy areas",
        "Increased density or opacity of lung tissue",
        "Air bronchograms",
      ],
      "Mass": [
        "Calcifications or mineralizations",
        "Shadowing",
        "Distortion or compression of tissues",
        "Anomalous structure or irregularity in shape"
      ],
      "Nodule": [
        "Nodular shape that protrudes into a cavity or airway",
        "Distinct edges or borders",
        "Calcifications or speckled areas",
        "Small round oral shaped spots",
        "White shadows"
      ],
      "Emphysema": [
        "Flattened hemidiaphragm",
        "Pulmonary bullae",
        "Hyperlucent lungs",
        "Horizontalisation of ribs",
        "Barrel Chest",
      ],
      "Fibrosis": [
        "Reticular shadowing of the lung peripheries",
        "Volume loss",
        "Thickened and irregular interstitial markings",
        "Bronchial dilation",
        "Shaggy heart borders"
      ],
      "Pleural Thickening": [
        "Thickened pleural line",
        "Loss of sharpness of the mediastinal border",
        "Calcifications on the pleura",
        "Lobulated peripheral shadowing",
        "Loss of lung volume",
      ],
      "Hernia": [
        "Bulge or swelling in the abdominal wall",
        "Protrusion of intestine or other abdominal tissue",
        "Swelling or enlargement of the herniated sac or surrounding tissues",
        "Retro-cardiac air-fluid level",
        "Thickening of intestinal folds"
      ]
    }